(function(n){var t={_storage:{},_subscribers:{},settings:{},info:{AppName:"Extensible Helper Class",Version:"1.1.0.0",Author:"Michael Schwarz"},addStorage:function(n){return this._storage[n]===undefined&&(this._storage[n]={}),this.getStorage(n)},getStorage:function(n){return this._storage[n]},storage:function(n){return this._storage[n]?this._storage[n]:this.addStorage(n)},subscribe:function(n,t){this._subscribers[n]?this._subscribers[n].push(t):(this._subscribers[n]=[],this.subscribe(n,t))},unsubscribe:function(n,t){if(this._subscribers[n])for(var i=0;i<this._subscribers[n].length;i++)if(this._subscribers[n][i]===t){this._subscribers[n].splice(i,1);break}},clearSubscriptions:function(n){this._subscribers[n]&&(this._subscribers[n]=[])},_trigger:function(t,i){var u,r,f;if(this._subscribers[t])for(u=this._subscribers[t],r=0;r<u.length;r++)f=u[r],f.apply(n,i)},trigger:function(n,t,i,r){var u=this;r?(this._trigger(n,t),i&&this.clearSubscriptions(n)):this.defer(function(){u._trigger(n,t);i&&u.clearSubscriptions(n)})},defer:function(n,t,i,r){this.is.function(n)&&setTimeout(function(){t?n.apply(t,i):i?n.apply(undefined,i):n()},r?r:1)},extend:function(n,t){t||(t=n,n=this);for(var i in t)t[i]!==undefined&&(n[i]=t[i])},each:function(n,t,i){if(n.length!==void 0){var r=0,u=n.length;if(i){for(;r<u;r++)if(t.apply(n[r],i)===!1)break}else for(;r<u;r++)if(t.call(n[r],r,n[r])===!1)break}return n},jsonParse:function(n){try{return JSON.parse(n)}catch(t){return console.error("JSON Parse Error ",t,"While Parsing: '",n,"'"),null}},jsonStringify:function(n){try{return JSON.stringify(n)}catch(n){return console.error("JSON Stringify Error ",n,"While Stringifying: ",n),null}},random:{_gen:function(n){for(var r=n.upper||65,i=n.lower||90,u=n.len||n.length||8,t="";t.length<u;)t+=Math.random()*100>=50?String.fromCharCode(Math.floor(Math.random()*(r-i)+i)):Math.floor(Math.random()*9).toString();return t},number:function(n,t){return Math.random()*(t-n)+n},string:function(n,t){var i=65,r=90;return t!==undefined&&t===!1&&(i=97,r=122),this._gen({upper:r,lower:i,len:n})},hex:function(n){return this._gen({upper:102,lower:97,len:n})},guid:function(){return"{0}-{1}-{2}-{3}-{4}".format(this.hex(8),this.hex(4),this.hex(4),this.hex(4),this.hex(12))},hexColor:function(){return"#"+this.hex(6)},date:function(n,i){if(!t.date)return console.error("exHelp: Date Extension not found!");var u=t.date.fix(i).getTime(),r=t.date.fix(n).getTime();return t.date.fix(Math.random()*(u-r)+r)}},array:{clone:function(n){return t.jsonParse(t.jsonStringify(n))},sieve:function(n){var r=n,i=function(n){var u,r;for(u in n)if(r=n[u],t.isString(r)){if(n[u]=r=r.trim(),r.trim().length==0)return n.splice(u,1),i(n)}else if(r===null||r===undefined)return n.splice(u,1),i(n);return n};return i(r)},contains:function(n,t){return n.indexOf(t)!==-1}},math:{rect:function(n,t,i,r){return{top:n?n:0,left:t?t:0,right:r?r:0,bottom:i?i:0,get width(){return this.right-this.left},get height(){return this.bottom-this.top},set width(n){this.right=this.left+n},set height(n){this.bottom=this.top+n},moveTopBy:function(n){this.top+=n;this.bottom+=n},moveTopTo:function(n){var t=this.height;this.top=n;this.bottom=this.top+t},moveLeftBy:function(n){this.left+=n;this.right+=n},moveLeftTo:function(n){var t=this.width;this.left=n;this.right=this.left+t},intersects:function(n){return this.left<=n.right&&n.left<=this.right&&this.top<=n.bottom&&n.top<=this.bottom},contains:function(n){return n.left<=this.right&&n.left>=this.left&&n.top<=this.bottom&&n.top>=this.top&&n.right<=this.right&&n.right>=this.left&&n.bottom<=this.bottom&&n.bottom>=this.top}}},easing:{linearTween:function(n,t,i,r){return i*n/r+t},easeInQuad:function(n,t,i,r){return n/=r,i*n*n+t},easeOutQuad:function(n,t,i,r){return n/=r,-i*n*(n-2)+t},easeInOutQuad:function(n,t,i,r){return(n/=r/2,n<1)?i/2*n*n+t:(n--,-i/2*(n*(n-2)-1)+t)},easeInCubic:function(n,t,i,r){return n/=r,i*n*n*n+t},easeOutCubic:function(n,t,i,r){return n/=r,n--,i*(n*n*n+1)+t},easeInOutCubic:function(n,t,i,r){return(n/=r/2,n<1)?i/2*n*n*n+t:(n-=2,i/2*(n*n*n+2)+t)},easeInQuart:function(n,t,i,r){return n/=r,i*n*n*n*n+t},easeOutQuart:function(n,t,i,r){return n/=r,n--,-i*(n*n*n*n-1)+t},easeInOutQuart:function(n,t,i,r){return(n/=r/2,n<1)?i/2*n*n*n*n+t:(n-=2,-i/2*(n*n*n*n-2)+t)},easeInQuint:function(n,t,i,r){return n/=r,i*n*n*n*n*n+t},easeOutQuint:function(n,t,i,r){return n/=r,n--,i*(n*n*n*n*n+1)+t},easeInOutQuint:function(n,t,i,r){return(n/=r/2,n<1)?i/2*n*n*n*n*n+t:(n-=2,i/2*(n*n*n*n*n+2)+t)},easeInSine:function(n,t,i,r){return-i*Math.cos(n/r*(Math.PI/2))+i+t},easeOutSine:function(n,t,i,r){return i*Math.sin(n/r*(Math.PI/2))+t},easeInOutSine:function(n,t,i,r){return-i/2*(Math.cos(Math.PI*n/r)-1)+t},easeInExpo:function(n,t,i,r){return i*Math.pow(2,10*(n/r-1))+t},easeOutExpo:function(n,t,i,r){return i*(-Math.pow(2,-10*n/r)+1)+t},easeInOutExpo:function(n,t,i,r){return(n/=r/2,n<1)?i/2*Math.pow(2,10*(n-1))+t:(n--,i/2*(-Math.pow(2,-10*n)+2)+t)},easeInCirc:function(n,t,i,r){return n/=r,-i*(Math.sqrt(1-n*n)-1)+t},easeOutCirc:function(n,t,i,r){return n/=r,n--,i*Math.sqrt(1-n*n)+t},easeInOutCirc:function(n,t,i,r){return(n/=r/2,n<1)?-i/2*(Math.sqrt(1-n*n)-1)+t:(n-=2,i/2*(Math.sqrt(1-n*n)+1)+t)}},Percentage:{XofY:function(n,t){return n/t*100}},Dist2D:function(n,t){if(n&&n.x!=undefined&&n.y!=undefined&&t&&t.x!=undefined&&t.y!=undefined){var i=t.x-n.x,r=t.y-n.y;return Math.sqrt(i*i+r*r)}return 0},Midpoint2D:function(n,t){return n&&n.x!=undefined&&n.y!=undefined&&t&&t.x!=undefined&&t.y!=undefined?{x:(n.x+t.x)/2,y:(n.y+t.y)/2}:{x:0,y:0}},Dist3D:function(n,t){if(n&&n.x!=undefined&&n.y!=undefined&&t&&t.x!=undefined&&t.y!=undefined){var i=t.x-n.x,r=t.y-n.y,u=t.z-n.z;return Math.sqrt(i*i+r*r+u*u)}return 0}},color:{_component:function(n){var t=n.toString(16);return t.length===1?"0"+t:t},HexToRGB:function(n){var t=/^#?([a-f\d]{2})([a-f\d]{2})([a-f\d]{2})$/i.exec(n);return{r:parseInt(t[1],16),g:parseInt(t[2],16),b:parseInt(t[3],16)}},HexToHSV:function(n){var t=this.HexToRGB(n);return this.RGBToHSV(t.r,t.g,t.b)},RGBToHex:function(n,i,r){if(n&&!i&&!r&&t.is.object(n))var u=n.r,f=n.g,e=n.b;else var u=n,f=i,e=r;return"#"+this._component(u)+this._component(f)+this._component(e)},RGBToHSV:function(){var f,e,o,i=arguments[0]/255,r=arguments[1]/255,u=arguments[2]/255,n,s,t=Math.max(i,r,u),h=t-Math.min(i,r,u),c=function(n){return(t-n)/6/h+1/2};return h==0?n=s=0:(s=h/t,f=c(i),e=c(r),o=c(u),i===t?n=o-e:r===t?n=1/3+f-o:u===t&&(n=2/3+e-f),n<0?n+=1:n>1&&(n-=1)),{h:Math.round(n*360),s:Math.round(s*100),v:Math.round(t*100)}},HSVToRGB:function(n,t,i){var r,u,f,h,c,e,o,s;if(n=Math.max(0,Math.min(360,n)),t=Math.max(0,Math.min(100,t)),i=Math.max(0,Math.min(100,i)),t/=100,i/=100,t==0)return r=u=f=i,[Math.round(r*255),Math.round(u*255),Math.round(f*255)];n/=60;h=Math.floor(n);c=n-h;e=i*(1-t);o=i*(1-t*c);s=i*(1-t*(1-c));switch(h){case 0:r=i;u=s;f=e;break;case 1:r=o;u=i;f=e;break;case 2:r=e;u=i;f=s;break;case 3:r=e;u=o;f=i;break;case 4:r=s;u=e;f=i;break;default:r=i;u=e;f=o}return{r:Math.round(r*255),g:Math.round(u*255),b:Math.round(f*255)}},HSVToHex:function(n,t,i){var r=this.HSVToRGB(n,t,i);return this.RGBToHex(r)},Saturate:function(n,i){var u=0,f=i||100,r;if(t.is.object(n)?n.h&&n.s&&n.v?u="HSV":n.r&&n.g&&n.b&&(u="RGB"):n.startsWith("#")&&(u="HEX"),u===0)return n;r=0;switch(u){case"HSV":r=n;break;case"RGB":r=this.RGBToHSV(n.r,n.g,n.b);break;case"HEX":r=this.HexToHSV(n)}r.s=f;switch(u){case"HSV":return r;case"RGB":return this.HSVToRGB(r.h,r.s,r.v);case"HEX":return this.HSVToHex(r.h,r.s,r.v)}},Lightness:function(n,i){var u=0,f=i||100,r;if(t.is.object(n)?n.h&&n.s&&n.v?u="HSV":n.r&&n.g&&n.b&&(u="RGB"):n.startsWith("#")&&(u="HEX"),u===0)return n;r=0;switch(u){case"HSV":r=n;break;case"RGB":r=this.RGBToHSV(n.r,n.g,n.b);break;case"HEX":r=this.HexToHSV(n)}r.v=f;switch(u){case"HSV":return r;case"RGB":return this.HSVToRGB(r.h,r.s,r.v);case"HEX":return this.HSVToHex(r.h,r.s,r.v)}}},cookies:{cookies:[],Read:function(){var r,t,n,i,u;for(this.cookies=[],r=document.cookie,t=r.split(";"),n=0;n<t.length;n++)i=t[n].split("="),u={name:i[0],value:i[1]},this.cookies.push(u)},Clear:function(){this.Read();for(var n=0;n<this.cookies.length;n++)$cookie=this.cookies[n],document.cookie="{0}=; expires={1}".format($cookie.name,new Date(0).toUTCString())}},string:{pad:function(n,t,i){t&&t!==""&&t.length!==0||(t=" ");i||(i=2);for(var r=""+n;n.length<i;)r=t+r;return r}},fullscreen:{_fromUser:!1,get isFullscreen(){return!(!document.fullscreenElement&&!document.mozFullScreenElement&&!document.webkitFullscreenElement&&!document.msFullscreenElement)},get isUserFullScreen(){return this.isFullscreen&&this._fromUser},enter:function(n){n||(n=document.documentElement);this.isFullscreen||(n.requestFullscreen?n.requestFullscreen():n.msRequestFullscreen?n.msRequestFullscreen():n.mozRequestFullScreen?n.mozRequestFullScreen():n.webkitRequestFullscreen&&n.webkitRequestFullscreen(Element.ALLOW_KEYBOARD_INPUT));this._fromUser=!0},exit:function(){this.isFullscreen&&(document.exitFullscreen?document.exitFullscreen():document.msExitFullscreen?document.msExitFullscreen():document.mozCancelFullScreen?document.mozCancelFullScreen():document.webkitExitFullscreen&&document.webkitExitFullscreen());this._fromUser=!1}},browser:{get isMobile(){return n.innerWidth<=1024?!0:!1},get isPortrait(){return n.innerWidth<n.innerHeight?!0:!1},get isTouch(){return"ontouchstart"in n},get isFirefox(){return navigator.userAgent.toLowerCase().indexOf("firefox")>-1},get isChrome(){return navigator.userAgent.toLowerCase().indexOf("chrome")>-1},get isSafari(){return navigator.userAgent.toLowerCase().indexOf("safari")>-1&&!this.isChrome||navigator.userAgent.toLowerCase().indexOf("applewebkit")>-1&&!this.isChrome},get isOpera(){return navigator.userAgent.toLowerCase().indexOf("opera")>-1},get isMSIE(){return navigator.userAgent.toLowerCase().indexOf("trident")>-1},get isEdge(){return navigator.userAgent.toLowerCase().indexOf("edge/")>-1},get isIEMobile(){return navigator.userAgent.toLowerCase().indexOf("iemobile")>-1},get isWindowsPhone(){return navigator.userAgent.toLowerCase().indexOf("windows phone")>-1},get isWebkit(){return navigator.userAgent.toLowerCase().indexOf("webkit")>-1},get isiOS(){return this.isSafari&&this.isTouch},get isiOS7(){return this.isiOS&&navigator.userAgent.toLowerCase().indexOf("os 7")>-1},get supportsHistoryAPI(){return!!(n.history&&history.pushState)}},net:{request:function(n,t){var i={method:"GET",data:null,progress:null,load:null,error:null,abort:null,finished:null},u,f;exHelp.extend(i,t);var r=new XMLHttpRequest,e=function(n){i.progress&&exHelp.is.function(i.progress)&&i.progress(n)},o=function(n){i.load&&exHelp.is.function(i.load)&&i.load(n)},s=function(n){i.error&&exHelp.is.function(i.error)&&i.error(n)},h=function(n){i.abort&&exHelp.is.function(i.abort)&&i.abort(n)},c=function(){switch(r.readyState){case XMLHttpRequest.DONE:var n=r.status==200;i.finished&&exHelp.is.function(i.finished)&&i.finished(n,r.responseText,r)}};r.onprogress=e;r.onabort=h;r.onerror=s;r.onload=o;r.onreadystatechange=c;r.open(i.method,n);i.data&&i.method=="POST"?(u="",f=function(n,t){var e=[],i,u,r;for(i in n)n.hasOwnProperty(i)&&(u=t?t+"["+i+"]":i,r=n[i],e.push(typeof r=="object"?f(r,u):encodeURIComponent(u)+"="+encodeURIComponent(r)));return e.join("&")},u=f(i.data),r.setRequestHeader("Content-type","application/x-www-form-urlencoded"),r.send(u)):r.send()}},is:{string:function(n){return!!(typeof n=="string"||n instanceof String)},"function":function(n){return!!(typeof n=="function"||n instanceof Function)},object:function(n){return!!(typeof n=="object"||n instanceof Object)},array:Array.isArray,arraylike:function(n){return n!==void 0&&n.length!==void 0},number:function(n){return!isNaN(n)&&isFinite(n)&&n!==!1&&n!==!0&&n!==null&&n!==undefined},mouse_event:function(n){return!!(typeof n=="MouseEvent"||n instanceof MouseEvent)},keyboard_event:function(n){return!!(typeof n=="KeyboardEvent"||n instanceof KeyboardEvent)}},browserNotification:{_mode:0,_permission:1,_api:null,_counter:0,permissions:{get ALLOWED(){return 0},get NOT_ALLOWED(){return 1},get DENIED(){return 2}},modes:{get NONE(){return 0},get W3C(){return 1},get WEBKIT(){return 2}},_list:[],Init:function(){if(this.Check_Support(!0))switch(this.Permission.Check(!0)){case this.permissions.NOT_ALLOWED:this.Permission.Request();p.browserNotification.Init()}},Check_Support:function(i){if(t.isSafari)return this._api=null,!1;var r=function(n){return!n||!n.checkPermission||!n.createNotification||!n.requestPermission?!1:!0};return r(n.Notification)&&i&&(this._api=n.Notification),r(n.webkitNotifications)&&i&&(this._api=n.webkitNotifications),i?!!this._api:r(n.Notification)||r(n.webkitNotifications)},Permission:{Check:function(n){if(t.browserNotification._api||t.browserNotification.Check_Support(!0)){var i=t.browserNotification._api.checkPermission();return n&&(t.browserNotification._permission=i),i}},Request:function(){return p.browserNotification._api.requestPermission()}},_Push_Basic:function(n){if(t.settings.useNativeNotifications&&this.Check_Support()&&this.Permission.Check()===this.permissions.ALLOWED){var f=n.title||t.info.AppName,e=n.content||n.msg||n.message||n.txt||n.text,o=n.img||n.pic||"favicon.png",r=n.show||n.onshow||n.onShow||n.display||n.ondisplay||n.onDisplay,u=n.close||n.onClose||n.hide||n.onHide,i=this._api.createNotification(o,f,e);return r&&exHelp.is.isFunction(r)&&(i.ondisplay=r),u&&exHelp.is.isFunction(u)&&(i.onclose=u),i.show(),this._list[this._counter.toString()]=i,{notification:i,id:this._counter++}}},Push:function(n,t){return this._Push_Basic({title:n,content:t})},PushWithImage:function(n,t,i){return this._Push_Basic({title:n,content:t,img:i})},PushAdvanced:function(n){return this._Push_Basic(n)}},locale:{_locale:"en",set:function(n){this._locale=n},getString:function(n){var i=t.storage("locale");return i[this._locale]&&i[this._locale][n]?i[this._locale][n]:n}}},i=function(n){t.extend(n)};n.exHelp=t;n.exHelpExtend=i})(window);String.prototype.format=function(){var n=arguments;return this.replace(/{(\d+)}/g,function(t,i){return"undefined"!=typeof n[i]?n[i]:t})};String.prototype.startsWith=function(n){return this.slice(0,n.length)==n};String.prototype.endsWith=function(n){return this.slice(-n.length)==n};String.prototype.contains=function(n){return this.indexOf(n)!==-1};String.prototype.repeat=function(n){for(var t=this,i="";;)if(n&1&&(i+=t),n>>=1,n)t+=t;else break;return i},function InitExHelp_ElementPlugin(n){if(n.exHelp==void 0||n.exHelpExtend==void 0)return setTimeout(InitExHelp_ElementPlugin,100,n);var t=function(n,i){return new t.functions.init(n,i)},u={e:t,isExElement:function(n){return!!(n instanceof exHelp.e)}},r="_dom_ready",i=function(){document.removeEventListener("DOMContentLoaded",i);n.removeEventListener("load",i);exHelp.trigger(r)};document.addEventListener("DOMContentLoaded",i);n.addEventListener("load",i);t.functions=t.prototype={constructor:t,init:function(i,r){var f,o,s,e,u;if(!i)return this;if(f=[],exHelp.is.string(i)){if(i.charAt(0)=="<"&&i.length>=3&&i.charAt(i.length-1)==">")return o=n.document.createElement("div"),o.innerHTML=i,f=o.childNodes,new t(f,r);for(f=n.document.querySelectorAll(i),u=0;u<f.length;u++)this[u]=f[u];this.length=f.length}else if(exHelp.is.arraylike(i)){for(e=i.length,u=0;u<e;u++)s=i[u]instanceof exHelp.e?i[u]:new t(i[u],r),s.length>0&&f.push(s[0]);for(e=f.length,u=0;u<e;u++)this[u]=f[u];this.length=f.length}else if(exHelp.is.object(i)){if(i instanceof exHelp.e)return i;this.context=this[0]=i;this.length=1}return this._applyOptions(r),this},length:0,each:function(n){for(var t=0;t<this.length;t++)if(n.call(this[t],t,this[t])===!1)return!1;return!0},_applyOptions:function(n){var i,t,r;for(i in n){t=n[i];switch(i.toLowerCase()){case"html":t.startsWith("__LOCALE__:")?(r=t.split(":")[1],this.setHtml(exHelp.locale.getString(r))):this.setHtml(t);break;case"class":this.addClass(t);break;case"width":case"height":case"top":case"left":case"right":case"bottom":case"position":this.setStyle(i,t);break;default:this.setAttr(i,t)}}},setAttr:function(n,t){return this.each(function(){this.setAttribute!==void 0&&this.setAttribute(n,t)}),this},getAttr:function(n){var t=null;return this.each(function(){if(this.getAttribute!==void 0&&(t=this.getAttribute(n)),t==null)for(var u=this.attributes,f=u.length,r=0;r<f;r++){var i=u[r],e=i.name||i.nodeName,o=i.value||i.nodeValue||i.textContent;if(e==n){t=o;break}}}),t},setHtml:function(n){return this.each(function(){this.innerHTML!==void 0?this.innerHTML=n:this.textContent!==void 0&&(this.textContent=n)}),this},getHtml:function(){var n=null;return this.each(function(){this.innerHTML!==void 0?n=this.innerHTML:this.textContent!==void 0&&(n=this.textContent)}),n},empty:function(){return this.setHtml("")},remove:function(){return this.each(function(){this.parentNode.removeChild(this)}),this},children:function(){var n=[];return this.each(function(){for(var t=0,i=this.childNodes,r=i.length;t<r;t++)n.push(i[t])}),new t(n)},find:function(n){if(!n)return new t([]);var u=[],i,f=n.charAt(0)==".",e=n.charAt(0)=="#",o=f||e?n.substr(1):n,r,s;return this.each(function(){if(i=new t(this),(f&&i.hasClass(o)||e&&i.getAttr("id")==o||!f&&!e&&i[0].nodeName.toLowerCase()==o.toLowerCase())&&u.push(this),this.childNodes.length>0&&(i=i.children().find(n),s=i.length,s>0))for(r=0;r<s;r++)u.push(i[r])}),new t(u)},exclusive:function(n){var e=[],i,r=n.charAt(0)==".",u=n.charAt(0)=="#",f=r||u?n.substr(1):n;return this.each(function(){i=new t(this);(r&&i.hasClass(f)||u&&i.getAttr("id")==f||!r&&!u&&i[0].nodeName.toLowerCase()==f.toLowerCase())&&e.push(this)}),new t(e)},getWidth:function(){return parseFloat(this.getComputedStyle("width"))},getHeight:function(){return parseFloat(this.getComputedStyle("height"))},getParents:function(n){var r=[],i=n!==undefined,f=i&&n.startsWith("."),e=i&&n.startsWith("#"),u=function(o){if(o){var s=new t(o);if(r.push(o),i&&(f&&s.hasClass(n)||e&&s.getAttr("id")==n))return!1;if(o.parentNode)return u(o.parentNode)}};return this.each(function(){this&&u(this.parentNode)}),new t(r)},getPageXY:function(){var i=document.fullScreenElement||document.msFullscreenElement||document.mozFullScreenElement||document.webkitFullscreenElement,n={x:0,y:0},t=function(r){exHelp.fullscreen.isFullscreen&&i==r||(n.x+=r.offsetLeft,n.y+=r.offsetTop,r.offsetParent&&t(r.offsetParent))};return this.each(function(){t(this)}),n},getPageBounds:function(){var n=this.getPageXY();return{left:n.x,top:n.y,right:n.x+this.getWidth(),bottom:n.y+this.getHeight()}},getRelativeXY:function(n){var i={x:0,y:0},r=n.charAt(0)==".",u=n.charAt(0)=="#",f=r||u?n.substr(1):n,e=function(n){var o=new t(n);if(r&&o.hasClass(f)||u&&o.getAttr("id")==f||!r&&!u&&o[0].nodeName.toLowerCase()==f.toLowerCase())return!1;i.x+=n.offsetLeft;i.y+=n.offsetTop;n.offsetParent&&e(n.offsetParent)};return this.each(function(){e(this)}),i},getRelativeBounds:function(n){var t=this.getRelativeXY(n);return{left:t.x,top:t.y,right:t.x+this.getWidth(),bottom:t.y+this.getHeight()}},getRelativeBoundingClientRect:function(){var n=null,t=this.getPageBounds();return(this.each(function(){n=this.getBoundingClientRect()}),n!=null)?{top:n.top-t.top,left:n.left-t.left,right:n.right-t.right,bottom:n.bottom-t.bottom,width:n.width,height:n.height}:t},getComputedStyle:function(t){var i=null;return this.each(function(){i=n.getComputedStyle?n.getComputedStyle(this,null).getPropertyValue(t):this.currentStyle?this.currentStyle[t]:this.style[t]}),i},addClass:function(n){var t=n.split(" ");return this.each(function(){for(var i=this.className.split(" "),n=0;n<t.length;n++)exHelp.array.contains(i,t[n])||i.push(t[n]);this.className=i.join(" ").trim()}),this},removeClass:function(n){var t=n.split(" ");return this.each(function(){for(var n=this.className.split(" "),i=0;i<t.length;i++)exHelp.array.contains(n,t[i])&&n.splice(n.indexOf(t[i]),1);this.className=n.join(" ").trim()}),this},toggleClass:function(n){var t=n.split(" ");return this.each(function(){for(var n=this.className.split(" "),i=0;i<t.length;i++)exHelp.array.contains(n,t[i])?n.splice(n.indexOf(t[i]),1):n.push(t[i]);this.className=n.join(" ").trim()}),this},hasClass:function(n){var t=!1;return this.each(function(){var i=this.className?this.className.split(" "):[];if(exHelp.array.contains(i,n))return t=!0,!1}),t},setStyle:function(n,t){this.each(function(){this.style[n]=t})},appendTo:function(n){return n=new t(n),this.each(function(){var t=this;n.each(function(){this.appendChild(t)})}),this},prependTo:function(n){return n=new t(n),this.each(function(){var t=this;n.each(function(){this.insertBefore(t,this.firstChild)})}),this},_evtQueue:function(){var n=[];this.add=function(t){n.push(t)};this.call=function(t){for(var i=0,r=n.length;i<r;i++)n[i].call(t)};this.remove=function(t){for(var r=[],i=0,u=n.length;i<u;i++)n[i]!==t&&r.push(n[i])};this.length=function(){return n.length}},on:function(n,i){var f=[],c=this,u,o,e,s,h;if(exHelp.is.string(n))if(n.contains(" "))f=n.split(" ");else if(n.contains(","))for(f=n.split(","),u=0;u<f.length;u++)f[u]=f[u].trim();else f.push(n);for(u=0,o=f.length;u<o;u++){e=f[u];switch(e){case"ready":exHelp.subscribe(r,i);break;case"tap":s=function(n){var i=!1,r=!1,u=new t(n);n.addEventListener("touchstart",function(){r=!1;i=!0;u.addClass("pressed")},{passive:!0});n.addEventListener("touchcancel",function(){r||(r=!0,i=!1,u.removeClass("pressed"))},{passive:!0});n.addEventListener("touchmove",function(u){var f,e;r||(f=new t(n).getPageBounds(),u&&u.touches&&u.touches.length>0&&(e=u.touches[0],(e.pageX<f.left||e.pageX>f.right||e.pageY<f.top||e.pageY>f.bottom)&&(i=!1,n.dispatchEvent(new TouchEvent("touchcancel")))))},{passive:!0});n.addEventListener("touchend",function(t){r||i&&(t&&t.preventDefault&&t.preventDefault(),t&&t.stopPropagation&&t.stopPropagation(),n._ehe_queue_tap.call(n),i=!1,u.removeClass("pressed"))})};this.each(function(){this._ehe_queue_tap||(this._ehe_queue_tap=new c._evtQueue);this._ehe_taphandler||(this._ehe_taphandler=new s(this));this._ehe_queue_tap.add(i)});break;case"resize":if(h=function(){var h,c,l,a,f;if(this instanceof Element){if(this._ehe_resize_handler)this._ehe_queue_resize.add(i);else{this._ehe_queue_resize||(this._ehe_queue_resize=new t.functions._evtQueue);this._ehe_queue_resize.add(i);this._ehe_resize_handler=document.createElement("div");var r=this,e="position: absolute; left: 0; top: 0; right: 0; bottom: 0; overflow: hidden; z-index: -1; visibility: hidden;";this._ehe_resize_handler.className="ehe-resize-event-dummy";this._ehe_resize_handler.style.cssText=e;this._ehe_resize_handler.innerHTML='<div class="resize-sensor-expand" style="{0}"><div style="{1}"><\/div><\/div><div class="resize-sensor-shrink" style="{0}"><div style="{1} width: 200%; height: 200%"><\/div><\/div>'.format(e,"position: absolute; left: 0; top: 0; transition: 0s;");this.appendChild(this._ehe_resize_handler);var n=this._ehe_resize_handler.childNodes[0],o=n.childNodes[0],u=this._ehe_resize_handler.childNodes[1],s=function(){o.style.width="100000px";o.style.height="100000px";n.scrollLeft=1e5;n.scrollTop=1e5;u.scrollLeft=1e5;u.scrollTop=1e5};s();f=function(){((l=r.offsetWidth)!=h||(a=r.offsetHeight)!=c)&&(r._ehe_queue_resize.call(this),h=l,c=a);s()};n.addEventListener("scroll",f);u.addEventListener("scroll",f)}return!1}},this.each(h)===!1)break;default:this.each(function(){this.addEventListener(e,i)})}}return this},off:function(n,t){var u=[],s=this,i,e,f,o;if(exHelp.is.string(n))if(n.contains(" "))u=n.split(" ");else if(n.contains(","))for(u=n.split(","),i=0;i<u.length;i++)u[i]=u[i].trim();else u.push(n);for(i=0,e=u.length;i<e;i++){f=u[i];switch(f){case"ready":exHelp.unsubscribe(r,t);break;case"tap":this.each(function(){this._ehe_queue_tap&&this._ehe_queue_tap.remove(t)});break;case"resize":if(o=function(){this instanceof Element&&this._ehe_queue_resize&&this._ehe_queue_resize.remove(t)},this.each(o)===!1)break;default:this.each(function(){this.removeEventListener(f,t)})}}return this}};t.functions.init.prototype=t.functions;t.extend=t.functions.extend=function(n){exHelp.extend(this,n)};n.exHelpExtend(u)}(window),function InitReader(n){if(n.exHelp==void 0||n.exHelpExtend==void 0||n.exHelp.e==void 0)return setTimeout(InitReader,100,n);var t=exHelp,i={reader:{container:null,path:null,render_canvas:null,sound:null,dbg_log:[],dbg:function(){},settings:{language:"en",show_go_to_page:!1,preload:!1,custom_background:null,custom_backgound_mode:null,start_page:1,no_pdf:!1,slideshow_mode:!1,slideshow_timing:5,slideshow_controls:!1,slideshow_pdf:!1,page_mode:"auto",page_sound:0,page_sound_volume:1,show_zoom:!0,enable_pinching:!1,enable_double_tapping:!1,enable_mousewheel_zoom:!1,zoom_max:4,zoom_min:"auto",zoom_doubleclick:1,zoom_wheel_step:.1,zoom_button_step:.1,enable_dragging:!0,enable_scrollbars:!1,show_fullscreen:!0,hide_in_fullscreen:!0,show_invert:!1,show_download:!1,show_overview:!0,overview_direction:"bottom",overview_overlay:!1,overview_size:150,overview_start_open:!1,enable_keyboard_navigation:!1,enable_swiping:!1,enable_arrows:!1,social_twitter:null,social_facebook:null,social_google:null,social_email:!1,enable_printing:!1,small_controls:!1},control_assignments:{overview:"bottomright-ver",fullscreen:"bottomright-ver",invert:"topright-hor","zoom-in":"topright-hor","zoom-out":"topright-hor","go-back":"left","go-fwd":"right",download:"bottomleft-hor",goto:"bottomleft-hor","ss-back":"bottom","ss-play":"bottom","ss-pause":"bottom","ss-fwd":"bottom"},elements:[{selector:".content",construct:"<div>",options:{"class":"content",tabindex:0},children:[{selector:".pages",options:{"class":"pages"},children:[{selector:".overlayer",options:{"class":"overlayer"}}]}]},{selector:".controls",options:{"class":"controls"},children:[{selector:".topleft",options:{"class":"topleft"},children:[{selector:".horizontal",options:{"class":"horizontal flex"}},{selector:".vertical",options:{"class":"vertical flex"}}]},{selector:".topright",options:{"class":"topright"},children:[{selector:".horizontal",options:{"class":"horizontal flex"}},{selector:".vertical",options:{"class":"vertical flex"}}]},{selector:".bottomleft",options:{"class":"bottomleft"},children:[{selector:".horizontal",options:{"class":"horizontal flex"}},{selector:".vertical",options:{"class":"vertical flex"}}]},{selector:".bottomright",options:{"class":"bottomright"},children:[{selector:".horizontal",options:{"class":"horizontal flex"}},{selector:".vertical",options:{"class":"vertical flex"}}]},{selector:".top",options:{"class":"top flex horizontal center-content"}},{selector:".left",options:{"class":"left flex vertical center-content"}},{selector:".bottom",options:{"class":"bottom flex horizontal center-content"}},{selector:".right",options:{"class":"right flex vertical center-content"}}]},{selector:".overviews",options:{"class":"overviews"}},{selector:".main-loader",options:{"class":"main-loader loader"}},{selector:".status",options:{"class":"status flex horizontal"},children:[{selector:".loader",options:{"class":"loader"},children:[{selector:".spinner",options:{"class":"spinner"}}]},{selector:".text",options:{"class":"text",html:"__LOCALE__:LOADING"}},{selector:".finished-overlay",options:{"class":"finished-overlay hidden",html:"__LOCALE__:LOADING_FINISHED"}},{selector:".error-overlay",options:{"class":"error-overlay hidden",html:"__LOCALE__:LOADING_ERROR"}}]},{selector:".render-canvas",construct:"<canvas>",options:{"class":"render-canvas"}}],checkFileExists:function(n,i){t.net.request(n,{method:"HEAD",finished:function(n,r,u){i&&t.is.function(i)&&i(n&&u.status==200)}})},makeMessage:function(n,i,r){var u=t.e("<div>",{"class":"message"}),e=t.e("<div>",{"class":"title",html:n}),o=t.e("<div>",{"class":"text",html:i}),f=t.e("<div>",{"class":"button",html:"OK"});e.appendTo(u);o.appendTo(u);f.appendTo(u);f.on("click",function(){u.remove();r&&t.is.function(r)&&r()});return u},loadPdfProcessor:function(n){var f=t.e("script"),i=null;if(f.each(function(){if(this.src.contains("magalone."))return i=this.src,!1}),i!=null){t.pager.current_script=i;var e=t.pager.current_script.substr(0,t.pager.current_script.lastIndexOf("/")),o=e+"/processing"+(t.pager.current_script.contains(".min")?".min":"")+".js",r=document.createElement("script"),u=!1;r.onload=function(){u||n();u=!0};r.setAttribute("src",o);document.getElementsByTagName("head")[0].appendChild(r)}},loadLocale:function(n){var f=t.e("script"),i=null;if(f.each(function(){if(this.src.contains("magalone."))return i=this.src,!1}),i!=null){t.pager.current_script=i;var e=t.pager.current_script.substr(0,t.pager.current_script.lastIndexOf("/")),o=e+"/locale/"+t.reader.settings.language+(t.pager.current_script.contains(".min")?".min":"")+".js",r=document.createElement("script"),u=!1;r.onload=function(){u||n();u=!0};r.setAttribute("src",o);document.getElementsByTagName("head")[0].appendChild(r)}},loadAudioPath:function(){var i=t.e("script"),n=null;return(i.each(function(){if(this.src.contains("magalone."))return n=this.src,!1}),n!=null)?(t.pager.current_script=n,t.pager.current_script.substr(0,t.pager.current_script.lastIndexOf("/")-3)+"/sound/page-flip-"):"./"},svgLoaded:!1,loadSvgFilters:function(){t.e('<svg version="1.1" xmlns:svg="http://www.w3.org/2000/svg" height="0"><filter id="invert"><feComponentTransfer><feFuncR type="table" tableValues="1 0"><\/feFuncR><feFuncG type="table" tableValues="1 0"><\/feFuncG><feFuncB type="table" tableValues="1 0"><\/feFuncB><\/feComponentTransfer><\/filter><\/svg>',{style:"display:none;"}).appendTo("body");this.svgLoaded=!0},playPageSound:function(){t.reader.sound!=null&&(t.reader.sound[0].pause(),t.reader.sound[0].currentTime=0,t.reader.sound[0].play())},get:function(n,i){var r=t.reader.container.getAttr("data-"+n),u=i===undefined?null:i;return r==null?u:r},getBoolean:function(n,t){var i=this.get(n),r=t===undefined?!1:t;return i==null?r:i=="true"},lastFullscreenElement:null,onFullscreenChange:function(){var n=document.fullScreenElement||document.msFullscreenElement||document.mozFullScreenElement||document.webkitFullscreenElement,i="";i=t.reader.lastFullscreenElement==null?"enter":"exit";t.trigger("fullscreen",[i,n||t.reader.lastFullscreenElement]);t.reader.lastFullscreenElement=n},init:function(){var n=this,i;this.container=t.e("#reader-container");this.container.length>0&&(this.path=this.get("path"));this.container.length>0&&this.path!=null&&this.path.length>0&&(this.settings.language=this.get("language","en"),t.locale.set(this.settings.language),this.settings.start_page=parseInt(this.get("start-page","1")),this.settings.no_pdf=this.getBoolean("no-pdf",!1),this.settings.show_fullscreen=this.getBoolean("show-fullscreen",!0),this.settings.hide_in_fullscreen=this.getBoolean("immersive-fullscreen",!1),this.settings.show_invert=this.getBoolean("show-invert"),this.settings.show_overview=this.getBoolean("show-thumbnails"),this.settings.overview_overlay=this.getBoolean("thumbnails-overlay"),this.settings.overview_direction=this.get("thumbnails-direction","bottom"),this.settings.overview_size=parseInt(this.get("thumbnails-size","150")),this.settings.overview_start_open=this.getBoolean("thumbnails-start-open"),this.settings.show_zoom=this.getBoolean("show-zoom"),this.settings.enable_pinching=this.getBoolean("enable-pinching"),this.settings.enable_double_tapping=this.getBoolean("enable-double-click"),this.settings.enable_mousewheel_zoom=this.getBoolean("enable-mouse-wheel"),this.settings.zoom_wheel_step=parseInt(this.get("zoom-wheel","10"))/100,this.settings.zoom_max=parseInt(this.get("zoom-max","400"))/100,this.settings.zoom_min=(i=this.get("zoom-min","auto"))=="auto"?"auto":parseInt(i)/100,this.settings.zoom_doubleclick=parseInt(this.get("zoom-doubleclick","100"))/100,this.settings.enable_keyboard_navigation=this.getBoolean("enable-keyboard",!0),this.settings.enable_swiping=this.getBoolean("enable-swiping",!0),this.settings.enable_arrows=this.getBoolean("enable-arrows",!0),this.settings.preload=this.getBoolean("preload",!0),this.settings.show_download=this.getBoolean("show-download",!1),this.settings.show_go_to_page=this.getBoolean("show-go-to-page",!1),this.settings.slideshow_mode=this.getBoolean("slideshow",!1),this.settings.slideshow_timing=parseFloat(this.get("slideshow-time","5")),this.settings.slideshow_controls=this.getBoolean("slideshow-show-controls",!1),this.settings.slideshow_pdf=this.getBoolean("slideshow-use-pdf",!1),this.settings.small_controls=this.getBoolean("small-controls",!1),this.settings.page_sound=parseInt(this.get("page-sound","0")),this.settings.page_sound_volume=parseInt(this.get("page-sound-volume","100"))/100,this.settings.page_mode=this.get("page-mode","auto"),this.settings.page_mode!="auto"&&(this.settings.page_mode=="single"?(t.pager.current_mode_manual=!0,t.pager.current_mode=t.pager.constant.SINGLE):this.settings.page_mode=="double"&&(t.pager.current_mode_manual=!0,t.pager.current_mode=t.pager.constant.DOUBLE)),this.loadLocale(function(){var i,r,u,f,e;if(n.prepareElements(),t.overlays.init(),document.addEventListener("fullscreenchange",t.reader.onFullscreenChange),document.addEventListener("mozfullscreenchange",t.reader.onFullscreenChange),document.addEventListener("webkitfullscreenchange",t.reader.onFullscreenChange),document.addEventListener("MSFullscreenChange",t.reader.onFullscreenChange),n.render_canvas=n.container.find(".render-canvas"),n.settings.enable_scrollbars&&n.container.find(".content").addClass("scrollbars"),n.settings.small_controls&&n.container.find(".controls").addClass("small"),n.settings.slideshow_mode&&(t.pager.current_mode_manual=!0,t.pager.current_mode=t.pager.constant.SINGLE),n.settings.page_sound>0&&n.settings.page_sound<=20){try{n.sound=t.e("<audio>",{preload:"auto"})}catch(o){n.sound=t.e("<audio>")}if(n.sound!=null){i=n.loadAudioPath();n.sound[0].canPlayType("audio/mp3")&&(r=t.e("<source>",{src:i+n.settings.page_sound+".mp3",type:"audio/mp3"}).appendTo(n.sound));n.sound[0].canPlayType("audio/aac")&&(u=t.e("<source>",{src:i+n.settings.page_sound+".aac",type:"audio/aac"}).appendTo(n.sound));n.sound[0].canPlayType("audio/ogg")&&(f=t.e("<source>",{src:i+n.settings.page_sound+".ogg",type:"audio/ogg"}).appendTo(n.sound));n.sound[0].canPlayType("audio/wav")&&(e=t.e("<source>",{src:i+n.settings.page_sound+".wav",type:"audio/wav"}).appendTo(n.sound));n.sound.appendTo(n.container);try{n.sound[0].volume=n.settings.page_sound_volume}catch(o){console.error("AUDIO is not supported by browser");n.sound=null}}}n.checkFileExists(n.path+"/cover_small.jpg",function(i){i?(n.prepareCover(),n.prepareData(),n.prepareControls()):t.net.request(n.path+"/upload.php",{method:"POST",data:{cmd:"ping"},finished:function(i,r){i&&r=="pong"?n.loadPdfProcessor(function(){t.processing.init(n.path)}):n.makeMessage(t.locale.getString("ERROR_TITLE"),t.locale.getString("ERROR_UPLOAD_PHP")).appendTo(n.container)}})})}))},setProgress:function(n){var i=t.e("div.status .text");n<0?i.setHtml(t.locale.getString("LOADING")):n>=0&&n<100?i.setHtml(n.toFixed(0)+"%"):n=="error"?(t.e(".error-overlay").removeClass("hidden"),setTimeout(function(){t.e(".status").addClass("gone")},1e3)):(t.e(".finished-overlay").removeClass("hidden"),setTimeout(function(){t.e(".status").addClass("gone")},1e3))},prepareControls:function(){var i={fullscreen:{selector:".ctrl.btn.fullscreen",options:{"class":"ctrl btn fullscreen"},children:[{selector:".icon.on",options:{"class":"icon on",html:"fullscreen_exit"}},{selector:".icon.off",options:{"class":"icon off",html:"fullscreen"}}]},overview:{selector:".ctrl.btn.overview",options:{"class":"ctrl btn overview"},children:[{selector:".icon",options:{"class":"icon",html:"view_module"}}]},invert:{selector:".ctrl.btn.invert",options:{"class":"ctrl btn invert"},children:[{selector:".icon",options:{"class":"icon",html:"invert_colors"}}]},"zoom-in":{selector:".ctrl.btn.zoom-in",options:{"class":"ctrl btn zoom-in"},children:[{selector:".icon",options:{"class":"icon",html:"zoom_in"}}]},"zoom-out":{selector:".ctrl.btn.zoom-out",options:{"class":"ctrl btn zoom-out"},children:[{selector:".icon",options:{"class":"icon",html:"zoom_out"}}]},"go-back":{selector:".ctrl.btn.go-back",options:{"class":"ctrl btn go-back"},children:[{selector:".icon",options:{"class":"icon",html:"keyboard_arrow_left"}}]},"go-fwd":{selector:".ctrl.btn.go-fwd",options:{"class":"ctrl btn go-fwd"},children:[{selector:".icon",options:{"class":"icon",html:"keyboard_arrow_right"}}]},download:{construct:"<a>",selector:".ctrl.btn.download",options:{"class":"ctrl btn download",href:t.pager.getPDFPath(),target:"_blank"},children:[{selector:".icon",options:{"class":"icon",html:"file_download"}}]},goto:{selector:".ctrl.btn.goto",options:{"class":"ctrl btn goto"},children:[{selector:".icon",options:{"class":"icon",html:"input"}}]},"ss-back":{selector:".ctrl.btn.ss-back",options:{"class":"ctrl btn ss-back"},children:[{selector:".icon",options:{"class":"icon",html:"skip_previous"}}]},"ss-play":{selector:".ctrl.btn.ss-play",options:{"class":"ctrl btn ss-play"},children:[{selector:".icon",options:{"class":"icon",html:"play_arrow"}}]},"ss-pause":{selector:".ctrl.btn.ss-pause",options:{"class":"ctrl btn ss-pause"},children:[{selector:".icon",options:{"class":"icon",html:"pause"}}]},"ss-fwd":{selector:".ctrl.btn.ss-fwd",options:{"class":"ctrl btn ss-fwd"},children:[{selector:".icon",options:{"class":"icon",html:"skip_next"}}]}},r={"topleft-hor":t.e(".controls .topleft .horizontal"),"topright-hor":t.e(".controls .topright .horizontal"),"bottomleft-hor":t.e(".controls .bottomleft .horizontal"),"bottomright-hor":t.e(".controls .bottomright .horizontal"),"topleft-ver":t.e(".controls .topleft .vertical"),"topright-ver":t.e(".controls .topright .vertical"),"bottomleft-ver":t.e(".controls .bottomleft .vertical"),"bottomright-ver":t.e(".controls .bottomright .vertical"),top:t.e(".controls .top"),left:t.e(".controls .left"),right:t.e(".controls .right"),bottom:t.e(".controls .bottom")},e=1,n,u,f;for(n in i)u=r[this.control_assignments[n]]||r["topleft-hor"],this._prepareElement(i[n],u).setAttr("tabindex",e++);if(this.settings.show_fullscreen){t.e(".ctrl.btn.fullscreen").on("click",function(n){(n&&n.preventDefault&&n.preventDefault(),n&&n.stopPropagation&&n.stopPropagation(),t.is.keyboard_event(n)&&n.keyCode!=13&&n.keyCode!=32)||(t.fullscreen.isFullscreen?t.fullscreen.exit():t.fullscreen.enter(t.reader.container[0]))});t.fullscreen.isFullscreen?t.e(".ctrl.btn.fullscreen").addClass("on").removeClass("off"):t.e(".ctrl.btn.fullscreen").addClass("off").removeClass("on");f=function(n,i){t.e(i).getAttr("id")=="reader-container"&&(n=="exit"?(t.e(".ctrl.btn:not(.fullscreen)").removeClass("immersive"),t.reader.container.removeClass("fullscreen"),t.pager.adjust({reload:!0}),t.e(".ctrl.btn.fullscreen").addClass("off").removeClass("on")):(t.reader.settings.hide_in_fullscreen&&t.e(".ctrl.btn:not(.fullscreen)").addClass("immersive"),t.reader.container.addClass("fullscreen"),t.pager.adjust({reload:!0}),t.e(".ctrl.btn.fullscreen").addClass("on").removeClass("off")),t.pager.calculateAutozoom())};t.subscribe("fullscreen",f)}else t.e(".ctrl.btn.fullscreen").addClass("gone");if(this.settings.show_overview)t.e(".ctrl.btn.overview").on("click tap",function(n){n&&n.preventDefault&&n.preventDefault();n&&n.stopPropagation&&n.stopPropagation();t.reader.overview.toggle()});else t.e(".ctrl.btn.overview").addClass("gone");if(this.settings.show_invert&&!t.browser.isMSIE)t.e(".ctrl.btn.invert").on("click tap",function(n){n&&n.preventDefault&&n.preventDefault();n&&n.stopPropagation&&n.stopPropagation();t.reader.toggleInvert()});else t.e(".ctrl.btn.invert").addClass("gone");if(this.settings.show_zoom){t.e(".ctrl.btn.zoom-in").on("click tap",function(n){n&&n.preventDefault&&n.preventDefault();n&&n.stopPropagation&&n.stopPropagation();t.pager.setZoom(t.pager.current_zoom+t.reader.settings.zoom_button_step);t.pager.adjust({reload:!0})});t.e(".ctrl.btn.zoom-out").on("click tap",function(n){n&&n.preventDefault&&n.preventDefault();n&&n.stopPropagation&&n.stopPropagation();t.pager.setZoom(t.pager.current_zoom-t.reader.settings.zoom_button_step);t.pager.adjust({reload:!0})})}else t.e([".ctrl.btn.zoom-in",".ctrl.btn.zoom-out"]).addClass("gone");if(this.settings.enable_arrows){t.e(".ctrl.btn.go-fwd").on("click tap",function(n){n&&n.preventDefault&&n.preventDefault();n&&n.stopPropagation&&n.stopPropagation();t.pager.current_animator==null?t.pager.goForward():t.pager.current_animator.doFullAnimationNext()});t.e(".ctrl.btn.go-back").on("click tap",function(n){n&&n.preventDefault&&n.preventDefault();n&&n.stopPropagation&&n.stopPropagation();t.pager.current_animator==null?t.pager.goBack():t.pager.current_animator.doFullAnimationPrev()})}else t.e([".ctrl.btn.go-fwd",".ctrl.btn.go-back"]).addClass("gone");if(this.settings.show_download)t.e(".ctrl.btn.download").on("click tap",function(n){n&&n.stopPropagation&&n.stopPropagation()});else t.e(".ctrl.btn.download").addClass("gone");if(this.settings.show_go_to_page)t.e(".ctrl.btn.goto").on("click tap",function(n){n&&n.preventDefault&&n.preventDefault();n&&n.stopPropagation&&n.stopPropagation()});else t.e(".ctrl.btn.goto").addClass("gone");if(this.settings.slideshow_mode&&this.settings.slideshow_controls){t.e(".ctrl.btn.ss-back").on("click tap",function(n){n&&n.preventDefault&&n.preventDefault();n&&n.stopPropagation&&n.stopPropagation();t.reader.slideshow.prev_manual()});t.e(".ctrl.btn.ss-fwd").on("click tap",function(n){n&&n.preventDefault&&n.preventDefault();n&&n.stopPropagation&&n.stopPropagation();t.reader.slideshow.next_manual()});t.e(".ctrl.btn.ss-pause").on("click tap",function(n){n&&n.preventDefault&&n.preventDefault();n&&n.stopPropagation&&n.stopPropagation();t.reader.slideshow.pause()});t.e(".ctrl.btn.ss-play").on("click tap",function(n){n&&n.preventDefault&&n.preventDefault();n&&n.stopPropagation&&n.stopPropagation();t.reader.slideshow.play()});t.e(".ctrl.btn.ss-play").addClass("gone")}else t.e([".ctrl.btn.ss-back",".ctrl.btn.ss-pause",".ctrl.btn.ss-play",".ctrl.btn.ss-fwd"]).addClass("gone")},slideshow:{timeout:null,play_timeout:function(){t.pager.goForward(function(){t.reader.slideshow.timeout=setTimeout(t.reader.slideshow.play_timeout,t.reader.settings.slideshow_timing*1e3);t.pager.current_page==t.pager.page_count&&(t.pager.current_page=0)})},play:function(){t.e(".ctrl.btn.ss-play").addClass("gone");t.e(".ctrl.btn.ss-pause").removeClass("gone");t.reader.slideshow.timeout=setTimeout(t.reader.slideshow.play_timeout,t.reader.settings.slideshow_timing*1e3)},pause:function(){t.e(".ctrl.btn.ss-pause").addClass("gone");t.e(".ctrl.btn.ss-play").removeClass("gone");clearTimeout(t.reader.slideshow.timeout)},next_manual:function(){t.reader.slideshow.pause();t.pager.goForward()},prev_manual:function(){t.reader.slideshow.pause();t.pager.goBack()}},overview:{isInited:!1,isFirstOpen:!0,isOpen:!1,container:null,thumbs:[],delta:0,interval:null,ensureInit:function(){if(!this.isInited){var i=this,o=n.requestAnimationFrame||n.mozRequestAnimationFrame||n.webkitRequestAnimationFrame||n.msRequestAnimationFrame,h=n.cancelAnimationFrame||n.mozCancelAnimationFrame;this.container=t.e("#reader-container .overviews");this.container.addClass(t.reader.settings.overview_direction+(t.reader.settings.overview_overlay?" float":" solid"));this.container.addClass("hidden");switch(t.reader.settings.overview_direction){case"left":case"right":this.container.setAttr("style","width: {0}px".format(t.reader.settings.overview_size));break;case"top":case"bottom":this.container.setAttr("style","height: {0}px".format(t.reader.settings.overview_size))}this.container.on("wheel",function(n){n&&n.preventDefault&&n.preventDefault();n&&n.stopPropagation&&n.stopPropagation();switch(t.reader.settings.overview_direction){case"left":case"right":i.container[0].scrollTop+=n.deltaY;break;case"top":case"bottom":i.container[0].scrollLeft+=n.deltaY}});var f=!1,r=null,u=null,e=1,s=function(n){if(n.type.startsWith("touch")){if(n.touches.length==1)return{x:n.touches[0].pageX,y:n.touches[0].pageY};if(n.touches.length==2){var i={x:n.touches[0].pageX,y:n.touches[0].pageY},r={x:n.touches[1].pageX,y:n.touches[1].pageY},u=t.math.Midpoint2D(i,r);return{x:u.x,y:u.y,dist:t.math.Dist2D(i,r)}}}else return{x:n.pageX,y:n.pageY}};this.container.on("touchstart mousedown",function(n){n&&n.preventDefault&&n.preventDefault();n&&n.stopPropagation&&n.stopPropagation();t.reader.overview.delta=0;f=!0;r=s(n);clearInterval(t.reader.overview.interval);clearTimeout(t.reader.overview.scrollTimeout)});this.container.on("touchmove mousemove",function(n){if(n&&n.preventDefault&&n.preventDefault(),n&&n.stopPropagation&&n.stopPropagation(),f){u=s(n);switch(t.reader.settings.overview_direction){case"left":case"right":t.reader.overview.delta=r.y-u.y;i.container[0].scrollTop+=t.reader.overview.delta;break;case"top":case"bottom":t.reader.overview.delta=r.x-u.x;i.container[0].scrollLeft+=t.reader.overview.delta}r=u}});this.container.on("touchend mouseup mouseleave",function(n){if(n&&n.preventDefault&&n.preventDefault(),n&&n.stopPropagation&&n.stopPropagation(),f=!1,Math.abs(t.reader.overview.delta)>=10){e=Math.abs(t.reader.overview.delta)/(t.pager.is_mobile?30:60);var r=function(){if(Math.abs(t.reader.overview.delta)>1){switch(t.reader.settings.overview_direction){case"left":case"right":i.container[0].scrollTop+=t.reader.overview.delta;break;case"top":case"bottom":i.container[0].scrollLeft+=t.reader.overview.delta}t.reader.overview.delta>0?t.reader.overview.delta-=e:t.reader.overview.delta+=e;t.reader.overview.interval=o(r)}else h(t.reader.overview.interval)};t.reader.overview.interval=o(r)}})}},open:function(){var i,e,u,o,h,r,n,s;if(this.ensureInit(),this.isFirstOpen){this.isFirstOpen=!1;i=t.pager.getPageSize(1,!0);e=8;switch(t.reader.settings.overview_direction){case"left":case"right":u=(t.reader.settings.overview_size-e*2)/i.width;break;case"top":case"bottom":u=(t.reader.settings.overview_size-e*2)/i.height}for(o={width:i.width*u,height:i.height*u},h=function(){Math.abs(t.reader.overview.delta)<10&&(t.pager.current_page=parseInt(t.e(this).getAttr("data-page")),t.pager.goToPage(t.pager.current_page))},r=0;r<t.pager.page_count;r++){n=t.e("<div>",{"class":"thumb","data-page":r+1});s=t.reader.stageLoader();s.load([t.pager.getThumbPath(r+1)]);s.appendTo(n);n.setAttr("style","width: {0}px; height: {1}px;".format(o.width,o.height));n.appendTo(this.container);var f=!1,c=function(){f=!0},l=function(){f&&(t.pager.current_page=parseInt(t.e(this).getAttr("data-page")),t.pager.goToPage(t.pager.current_page),f=!1)},a=function(){f=!1};n.on("mousedown touchstart",c);n.on("mouseup touchend",l);n.on("mousemove mousecancel touchmove touchcancel",a)}}this.container.removeClass("hidden");t.e("#reader-container .controls").setAttr("style","{0}: {1}px;".format(t.reader.settings.overview_direction,t.reader.settings.overview_size));t.reader.settings.overview_overlay||t.pager.content_container.setAttr("style","{0}: {1}px;".format(t.reader.settings.overview_direction,t.reader.settings.overview_size));this.scrollToCurrentPage();this.isOpen=!0},scrollTimeout:null,scrollToCurrentPage:function(){var i=t.e(".thumb[data-page='{0}']".format(t.pager.current_page_firstvalid)),l=n.requestAnimationFrame||n.mozRequestAnimationFrame||n.webkitRequestAnimationFrame||n.msRequestAnimationFrame,a=n.cancelAnimationFrame||n.mozCancelAnimationFrame,r,h,c;if(i&&i.length>0){t.e(".thumb").removeClass("active");t.pager.current_mode==t.pager.constant.SINGLE||t.pager.current_mode==t.pager.constant.SINGLE_REVERSE?i.addClass("active"):t.e(".thumb[data-page='{0}'], .thumb[data-page='{1}']".format(t.pager.current_page_left,t.pager.current_page_right)).addClass("active");r=t.reader.settings.overview_direction=="left"||t.reader.settings.overview_direction=="right"?i[0].offsetTop-(i[0].offsetHeight+this.container[0].offsetHeight)/2+i[0].offsetHeight:i[0].offsetLeft-(i[0].offsetWidth+this.container[0].offsetWidth)/2+i[0].offsetWidth;(t.pager.current_mode==t.pager.constant.DOUBLE||t.pager.current_mode==t.pager.constant.DOUBLE_REVERSE)&&(r+=(t.reader.settings.overview_direction=="left"||t.reader.settings.overview_direction=="right"?i[0].offsetHeight/2:i[0].offsetWidth/2)+16);var u=0,f=60,v=Math.abs(this.container[0].scrollTop-r)/f,e=this,o=r-this.container[0].scrollTop,s=this.container[0].scrollTop;(t.reader.settings.overview_direction=="top"||t.reader.settings.overview_direction=="bottom")&&(o=r-this.container[0].scrollLeft,s=this.container[0].scrollLeft);h=function(n,t,i,r){return(n/=r/2,n<1)?i/2*n*n+t:(n--,-i/2*(n*(n-2)-1)+t)};c=function(){t.reader.settings.overview_direction=="left"||t.reader.settings.overview_direction=="right"?e.container[0].scrollTop=h(u,s,o,f):e.container[0].scrollLeft=h(u,s,o,f);u++;u<f?e.scrollTimeout=l(c):a(e.scrollTimeout)};a(this.scrollTimeout);this.scrollTimeout=l(c)}},close:function(){this.ensureInit();this.container.addClass("hidden");t.pager.content_container.setAttr("style","");t.e("#reader-container .controls").setAttr("style","");this.isOpen=!1},toggle:function(){this.isOpen?this.close():this.open()}},prepareData:function(){t.net.request(this.path+"/data.json",{finished:function(n,i){n&&(t.pager.pages=t.jsonParse(i),t.pager.init())}})},prepareCover:function(){var n=this.stageLoader();n.addClass("cover-loader");n.appendTo(".main-loader");n.load([this.path+"/cover_small.jpg",this.path+"/cover_medium.jpg",this.path+"/cover_big.jpg",])},prepareElements:function(){for(var n in this.elements)this._prepareElement(this.elements[n],this.container)},_prepareElement:function(n,i){var r,u,f=this;if(r=i.find(n.selector),r.length==0&&(r=t.e(n.construct||"<div>",n.options),r.appendTo(i)),n.children!==void 0)for(u in n.children)this._prepareElement(n.children[u],r);return r},make_slider:function(n){var i=t.e("<div>",{"class":"slider",value:50}),s=t.e("<div>",{"class":"track"}).appendTo(i),h=t.e("<div>",{"class":"fill"}).appendTo(s),u=t.e("<div>",{"class":"thumb"}).appendTo(i),c=t.e("<div>",{"class":"buffer"}),f=null,e=null,o=!1,r={slider:{max:n.max||100,min:n.min||0,value:n.value||50,sigfigs:n.sigfigs!=undefined?n.sigfigs:-1,dragging:!1,update:function(n,s){var c=r.slider,l=t.math.Percentage.XofY(c.value,c.max),a;o?(h.setStyle("height",l+"%"),u.setStyle("bottom",l+"%")):(h.setStyle("width",l+"%"),u.setStyle("left",l+"%"));a=c.value+0;e&&t.is.function(e)&&(a=e(a));u.setAttr("value",c.value);i.setAttr("value",c.value);i.setAttr("max",c.max);i.setAttr("min",c.min);!n&&f&&t.is.function(f)&&f(c.value,!!s)},set:function(n){var t=r.slider;t.value=n;t.update},setBuffer:function(n){c.setStyle("width",100-n+"%")},onStart:function(){var n=r.slider;n.dragging=!0;u.addClass("pressed")},onEnd:function(){var n=r.slider;n.dragging=!1;u.removeClass("pressed")},onDrag:function(n){var u=r.slider,f,e,s;u.dragging&&(f=u.getPos(n),o?(e=i.getHeight(),u.value=t.math.Percentage.XofY(e-f.y,e)/100*u.max+u.min):(s=i.getWidth(),u.value=t.math.Percentage.XofY(f.x,s)/100*u.max+u.min),u.sigfigs!=-1&&(u.value=u.value.toFixed(u.sigfigs)),u.value=Math.min(u.max,Math.max(u.min,u.value)),u.update(undefined,!0))},getPos:function(n){var t=i.getPageXY();if(n.type.startsWith("touch")){if(n.touches.length==1)return{x:n.touches[0].pageX-t.x,y:n.touches[0].pageY-t.y}}else return{x:n.pageX-t.x,y:n.pageY-t.y}}}};n&&(n.dark&&i.addClass("dark"),n.discrete&&i.addClass("discrete"),n.callback&&(f=n.callback),n.displayCallback&&(e=n.displayCallback),n.vertical&&(o=!0),n.buffering&&c.appendTo(s),n.buffer&&r.setBuffer(n.buffer));o&&i.addClass("vertical");i.extend(r);i.slider.update();u.on("mousedown touchstart",r.slider.onStart);i.on("mousemove touchmove",r.slider.onDrag);t.e("body").on("mouseup touchend",r.slider.onEnd);return i},stageLoaderId:0,stageLoader:function(){var i=t.e("<div>",{"class":"loader"}),r=t.e("<div>",{"class":"spinner"}).appendTo(i),u=++t.reader.stageLoaderId,n={currentStage:-1,instanceId:0,sources:[],elements:[],spinner:null,callback:null,loadInstance:null,load:function(r,u,f){var o,e;if(r){for(o=!0,e=0;e<r.length;e++)if(r[e]!=n.sources[e]){o=!1;break}if(o){u&&t.is.function(u)&&u();return}for(n.sources=r,n.spinner.removeClass("hidden"),e=0;e<n.elements.length;e++)n.elements[e].remove();for(n.elements=[],e=0;e<n.sources.length;e++)n.elements[e]=t.e("<img>",{"class":f&&e==0?"":"loading"}).appendTo(i)}n.callback=u;n.loadInstance=new n.loadEvent(++n.instanceId);n.currentStage=-1;n.loadInstance.onLoad()},loadEvent:function(i){var r=this;this.id=i;this.onLoad=function(){if(r.id==n.instanceId)if(n.currentStage>=0&&(n.spinner.addClass("hidden"),n.elements[n.currentStage]&&n.elements[n.currentStage].removeClass("loading")),n.currentStage++,n.currentStage<n.sources.length){n.elements[n.currentStage].on("load",r.onLoad);n.elements[n.currentStage].setAttr("src",n.sources[n.currentStage])}else if(n.callback&&t.is.function(n.callback)){if(r.id!=n.instanceId)return;n.callback();n.callback=null}}}};return n.spinner=r,exHelp.extend(i,n),i},isInvertOn:!1,toggleInvert:function(){this.isInvertOn?(t.reader.container.removeClass("invert"),this.isInvertOn=!1):(t.reader.container.addClass("invert"),this.isInvertOn=!0)}},swipe_animator:{listen:!0,dragging:!1,dragged:null,revealed:null,moveStart:null,size:null,last:null,target:null,direction:"none",animationTimeout:null,init:function(){t.e(document).on("mousedown touchstart",this.listenerStart);t.e(document).on("mousemove touchmove",this.listenerMove);t.e(document).on("mouseup touchend mouseleave touchleave",this.listenerEnd)},destruct:function(){t.e(document).off("mousedown touchstart",this.listenerStart);t.e(document).off("mousemove touchmove",this.listenerMove);t.e(document).off("mouseup touchend mouseleave touchleave",this.listenerEnd)},intersects:function(n,t){return n.x>t.left&&n.x<t.right&&n.y>t.top&&n.y<t.bottom},posFromEvent:function(n){if(n.type.startsWith("touch")){if(n.touches.length==1)return{x:n.touches[0].pageX,y:n.touches[0].pageY};if(n.touches.length==2){var i={x:n.touches[0].pageX,y:n.touches[0].pageY},r={x:n.touches[1].pageX,y:n.touches[1].pageY},u=t.math.Midpoint2D(i,r);return{x:u.x,y:u.y,dist:t.math.Dist2D(i,r)}}}else return{x:n.pageX,y:n.pageY}},animateRight:function(n){var r=t.swipe_animator,i=t.pager.constant,u=t.pager.current_mode==i.DOUBLE||t.pager.current_mode==i.DOUBLE_REVERSE?r.size.width*2:r.size.width,o=u-n,f=Math.min(1,n/u),e=t.math.easing.easeOutQuad(f*100,0,100,100)/100;clearTimeout(r.animationTimeout);t.pager.current_mode==i.DOUBLE||t.pager.current_mode==i.DOUBLE_REVERSE?(r.revealed=t.e([t.pager.holders[i.CUR_LEFT],t.pager.holders[i.CUR_RIGHT]]),r.dragged=t.e([t.pager.holders[i.NEXT_LEFT],t.pager.holders[i.NEXT_RIGHT]]),t.e([t.pager.holders[i.PREV_LEFT],t.pager.holders[i.PREV_LEFT]]).addClass("hidden"),t.pager.showPage(t.pager.current_page_left+2)?t.e(t.pager.holders[i.NEXT_LEFT]).removeClass("hidden"):t.e(t.pager.holders[i.NEXT_LEFT]).addClass("hidden"),t.pager.showPage(t.pager.current_page_right+2)?t.e(t.pager.holders[i.NEXT_RIGHT]).removeClass("hidden"):t.e(t.pager.holders[i.NEXT_RIGHT]).addClass("hidden"),t.pager.showPage(t.pager.current_page_left)?t.e(t.pager.holders[i.CUR_LEFT]).removeClass("hidden"):t.e(t.pager.holders[i.CUR_LEFT]).addClass("hidden"),t.pager.showPage(t.pager.current_page_right)?t.e(t.pager.holders[i.CUR_RIGHT]).removeClass("hidden"):t.e(t.pager.holders[i.CUR_RIGHT]).addClass("hidden")):(r.revealed=t.pager.holders[i.CUR],r.dragged=t.pager.holders[i.NEXT],t.pager.holders[i.PREV].addClass("hidden"),t.pager.holders[i.NEXT].removeClass("hidden"));r.dragged.addClass("animate");r.revealed.addClass("wait");t.overlays.setHidden(!0);r.dragged.setStyle("transform","translate({0}px, 0)".format(u-u*e));r.revealed.setStyle("transform","translate(-{0}%, 0)".format(20*e));r.dragged.setStyle("opacity",1*t.math.easing.easeOutExpo(f*1e3,0,1,100));r.revealed.setStyle("opacity",10-t.math.easing.easeOutExpo(f*100,0,10,100))},animateLeft:function(n){var r=t.swipe_animator,i=t.pager.constant,u=t.pager.current_mode==i.DOUBLE||t.pager.current_mode==i.DOUBLE_REVERSE?r.size.width*2:r.size.width,o=u-n,f=Math.min(1,n/u),e=t.math.easing.easeOutQuad(f*100,0,100,100)/100;clearTimeout(r.animationTimeout);t.pager.current_mode==i.DOUBLE||t.pager.current_mode==i.DOUBLE_REVERSE?(r.revealed=t.e([t.pager.holders[i.CUR_LEFT],t.pager.holders[i.CUR_RIGHT]]),r.dragged=t.e([t.pager.holders[i.PREV_LEFT],t.pager.holders[i.PREV_RIGHT]]),t.e([t.pager.holders[i.NEXT_LEFT],t.pager.holders[i.NEXT_RIGHT]]).addClass("hidden")):(r.dragged=t.pager.holders[i.PREV],r.revealed=t.pager.holders[i.CUR],t.pager.holders[i.PREV].removeClass("hidden"),t.pager.holders[i.NEXT].addClass("hidden"));r.dragged.addClass("animate").removeClass("hidden");r.revealed.addClass("wait").removeClass("hidden");t.overlays.setHidden(!0);r.dragged.setStyle("transform","translate(-{0}px, 0)".format(u-u*e));r.revealed.setStyle("transform","translate({0}%, 0)".format(20*e));r.dragged.setStyle("opacity",1*t.math.easing.easeOutExpo(f*1e3,0,1,100));r.revealed.setStyle("opacity",10-t.math.easing.easeOutExpo(f*100,0,10,100))},animateRightTo:function(i,r,u){var f=t.swipe_animator,l=t.pager.constant,e=0,o=30,s=n.requestAnimationFrame||n.mozRequestAnimationFrame||n.webkitRequestAnimationFrame||n.msRequestAnimationFrame,h=n.cancelAnimationFrame||n.mozCancelAnimationFrame,c=function(){f.animateRight(t.math.easing.easeInOutQuad(e++,i,r-i,o));e<o?f.animationTimeout=s(c):t.is.function(u)&&(u(),h(f.animationTimeout))};h(f.animationTimeout);f.animationTimeout=s(c)},animateLeftTo:function(i,r,u){var f=t.swipe_animator,l=t.pager.constant,e=0,o=30,s=n.requestAnimationFrame||n.mozRequestAnimationFrame||n.webkitRequestAnimationFrame||n.msRequestAnimationFrame,h=n.cancelAnimationFrame||n.mozCancelAnimationFrame,c=function(){f.animateLeft(t.math.easing.easeInOutQuad(e++,i,r-i,o));e<o?f.animationTimeout=s(c):t.is.function(u)&&(u(),h(f.animationTimeout))};h(f.animationTimeout);f.animationTimeout=s(c)},listenerStart:function(n){var i=t.swipe_animator,o=t.pager.constant;if(!i.lockAnimation&&!t.pager.touchBlocked&&t.pager.current_animation==o.SWIPE)if(t.pager.current_mode==o.DOUBLE||t.pager.current_mode==o.DOUBLE_REVERSE){var u=t.pager.holders[o.CUR_LEFT][0].getBoundingClientRect(),f=t.pager.holders[o.CUR_RIGHT][0].getBoundingClientRect(),s={top:u.top,left:u.left,right:u.left+u.width*.1,bottom:u.bottom},h={top:f.top,left:f.right-f.width*.1,right:f.right,bottom:f.bottom},e=i.posFromEvent(n);i.intersects(e,h)?(i.size={width:u.width||f.width,height:u.height||f.height},i.target=t.pager.page_container[0].getBoundingClientRect(),i.target={top:i.target.top+t.pager.current_padding,left:i.target.left+t.pager.current_padding,right:i.target.right-t.pager.current_padding,bottom:i.target.bottom-t.pager.current_padding},i.moveStart=e,t.pager.paging_handled_by_animator=!0,i.startDragRight()):i.intersects(e,s)&&(i.size={width:u.width||f.width,height:u.height||f.height},i.target=t.pager.page_container[0].getBoundingClientRect(),i.target={top:i.target.top+t.pager.current_padding,left:i.target.left+t.pager.current_padding,right:i.target.right-t.pager.current_padding,bottom:i.target.bottom-t.pager.current_padding},i.moveStart=e,t.pager.paging_handled_by_animator=!0,i.startDragLeft())}else{var r=t.pager.holders[o.CUR][0].getBoundingClientRect(),s={top:r.top,left:r.left,right:r.left+r.width*.1,bottom:r.bottom},h={top:r.top,left:r.right-r.width*.1,right:r.right,bottom:r.bottom},e=i.posFromEvent(n);i.size={width:r.width,height:r.height};i.target=t.pager.page_container[0].getBoundingClientRect();i.target={top:i.target.top+t.pager.current_padding,left:i.target.left+t.pager.current_padding,right:i.target.right-t.pager.current_padding,bottom:i.target.bottom-t.pager.current_padding};i.moveStart=e;i.intersects(e,h)?(t.pager.paging_handled_by_animator=!0,i.startDragRight()):i.intersects(e,s)&&(t.pager.paging_handled_by_animator=!0,i.startDragLeft())}},listenerMove:function(n){var i=t.swipe_animator,f=t.pager.constant,r,u;!i.lockAnimation&&i.dragging&&(r=i.posFromEvent(n),i.last=r,i.direction=="right"?(u=Math.abs(i.target.right-r.x),i.animateRight(u)):i.direction=="left"&&(u=Math.abs(i.target.left-r.x),i.animateLeft(u)))},listenerEnd:function(){var n=t.swipe_animator,e=t.pager.constant,f,r;if(!n.lockAnimation&&n.dragging)if(t.reader.playPageSound(),f=n.last,r=function(){n.dragged.removeClass("animate");n.revealed.removeClass("wait");n.dragged.setStyle("transform","");n.revealed.setStyle("transform","");t.pager.paging_handled_by_animator=!1;n.last=null;n.lockAnimation=!1;t.overlays.setHidden(!1)},n.direction=="right"){var i=f!=null?Math.abs(n.target.right-f.x):0,u=t.pager.current_mode==e.DOUBLE||t.pager.current_mode==e.DOUBLE_REVERSE?n.size.width*2:n.size.width,o=u/10;i<u?i>=o?n.animateRightTo(i,u,function(){t.pager.goForward(function(){r()})}):n.animateRightTo(i,0,function(){r()}):t.pager.goForward(function(){r()})}else if(n.direction=="left"){var i=f!=null?Math.abs(n.target.left-f.x):0,u=t.pager.current_mode==e.DOUBLE||t.pager.current_mode==e.DOUBLE_REVERSE?n.size.width*2:n.size.width,o=u/8;i<u?i>=o?n.animateLeftTo(i,u,function(){t.pager.goBack(function(){r()})}):n.animateLeftTo(i,0,function(){r()}):t.pager.goBack(function(){r()})}n.dragging=!1},lockAnimation:!1,doFullAnimationNext:function(n){var i=t.swipe_animator,r=t.pager.constant,e;if(!i.lockAnimation&&t.pager.can_go_forward){i.lockAnimation=!0;t.reader.playPageSound();var s=i.last,o=function(){i.dragged.removeClass("animate");i.revealed.removeClass("wait");i.dragged.setStyle("transform","");i.revealed.setStyle("transform","");n&&t.is.function(n)&&n();i.lockAnimation=!1;t.pager.paging_handled_by_animator=!1;i.last=null;t.overlays.setHidden(!1)},u=t.pager.holders[r.CUR_LEFT][0].getBoundingClientRect(),f=t.pager.holders[r.CUR_RIGHT][0].getBoundingClientRect();i.size={width:u.width||f.width,height:u.height||f.height};i.target=t.pager.page_container[0].getBoundingClientRect();i.target={top:i.target.top+t.pager.current_padding,left:i.target.left+t.pager.current_padding,right:i.target.right-t.pager.current_padding,bottom:i.target.bottom-t.pager.current_padding};e=t.pager.current_mode==r.DOUBLE||t.pager.current_mode==r.DOUBLE_REVERSE?i.size.width*2:i.size.width;i.direction="right";i.animateRightTo(0,e,function(){t.pager.goForward(null,function(){o()})})}},doFullAnimationPrev:function(n){var i=t.swipe_animator,r=t.pager.constant,e;if(!i.lockAnimation&&t.pager.can_go_back){i.lockAnimation=!0;t.reader.playPageSound();var s=i.last,o=function(){i.dragged.removeClass("animate");i.revealed.removeClass("wait");i.dragged.setStyle("transform","");i.revealed.setStyle("transform","");n&&t.is.function(n)&&n();i.lockAnimation=!1;t.pager.paging_handled_by_animator=!1;i.last=null;t.overlays.setHidden(!1)},u=t.pager.holders[r.CUR_LEFT][0].getBoundingClientRect(),f=t.pager.holders[r.CUR_RIGHT][0].getBoundingClientRect();i.size={width:u.width||f.width,height:u.height||f.height};i.target=t.pager.page_container[0].getBoundingClientRect();i.target={top:i.target.top+t.pager.current_padding,left:i.target.left+t.pager.current_padding,right:i.target.right-t.pager.current_padding,bottom:i.target.bottom-t.pager.current_padding};e=t.pager.current_mode==r.DOUBLE||t.pager.current_mode==r.DOUBLE_REVERSE?i.size.width*2:i.size.width;i.direction="left";i.animateLeftTo(0,e,function(){t.pager.goBack(null,function(){o()})})}},startDragRight:function(){var r=t.swipe_animator,i=t.pager.constant,u=n.cancelAnimationFrame||n.mozCancelAnimationFrame;r.dragging=!0;u(r.animationTimeout);t.pager.current_mode==i.DOUBLE||t.pager.current_mode==i.DOUBLE_REVERSE?(r.revealed=t.e([t.pager.holders[i.CUR_LEFT],t.pager.holders[i.CUR_RIGHT]]),r.dragged=t.e([t.pager.holders[i.NEXT_LEFT],t.pager.holders[i.NEXT_RIGHT]]),t.e([t.pager.holders[i.PREV_LEFT],t.pager.holders[i.PREV_LEFT]]).addClass("hidden"),t.pager.showPage(t.pager.current_page_left+2)?t.e(t.pager.holders[i.NEXT_LEFT]).removeClass("hidden"):t.e(t.pager.holders[i.NEXT_LEFT]).addClass("hidden"),t.pager.showPage(t.pager.current_page_right+2)?t.e(t.pager.holders[i.NEXT_RIGHT]).removeClass("hidden"):t.e(t.pager.holders[i.NEXT_RIGHT]).addClass("hidden"),t.pager.showPage(t.pager.current_page_left)?t.e(t.pager.holders[i.CUR_LEFT]).removeClass("hidden"):t.e(t.pager.holders[i.CUR_LEFT]).addClass("hidden"),t.pager.showPage(t.pager.current_page_right)?t.e(t.pager.holders[i.CUR_RIGHT]).removeClass("hidden"):t.e(t.pager.holders[i.CUR_RIGHT]).addClass("hidden")):(r.revealed=t.pager.holders[i.CUR],r.dragged=t.pager.holders[i.NEXT],t.pager.holders[i.PREV].addClass("hidden"));r.dragged.addClass("animate");r.revealed.addClass("wait");r.dragged.setStyle("transform","translate(200%, 0)");r.revealed.setStyle("transform","translate(0%, 0)");r.direction="right"},startDragLeft:function(){var i=t.swipe_animator,r=t.pager.constant,u=n.cancelAnimationFrame||n.mozCancelAnimationFrame;i.dragging=!0;u(i.animationTimeout);t.pager.current_mode==r.DOUBLE||t.pager.current_mode==r.DOUBLE_REVERSE?(i.revealed=t.e([t.pager.holders[r.CUR_LEFT],t.pager.holders[r.CUR_RIGHT]]),i.dragged=t.e([t.pager.holders[r.PREV_LEFT],t.pager.holders[r.PREV_RIGHT]]),t.e([t.pager.holders[r.NEXT_LEFT],t.pager.holders[r.NEXT_RIGHT]]).addClass("hidden")):(i.dragged=t.pager.holders[r.PREV],i.revealed=t.pager.holders[r.CUR],t.pager.holders[r.NEXT].addClass("hidden"));i.dragged.addClass("animate").removeClass("hidden");i.revealed.addClass("wait").removeClass("hidden");i.dragged.setStyle("transform","translate(-200%, 0)");i.revealed.setStyle("transform","translate(0%, 0)");i.direction="left"}},flip_animator:{listen:!0,dragging:!1,dragged:null,revealed:null,hidden:null,fullhidden:null,moveStart:null,size:null,last:null,target:null,direction:"none",animationTimeout:null,init:function(){t.e(document).on("mousedown touchstart",this.listenerStart);t.e(document).on("mousemove touchmove",this.listenerMove);t.e(document).on("mouseup touchend mouseleave touchleave",this.listenerEnd)},destruct:function(){t.e(document).off("mousedown touchstart",this.listenerStart);t.e(document).off("mousemove touchmove",this.listenerMove);t.e(document).off("mouseup touchend mouseleave touchleave",this.listenerEnd)},intersects:function(n,t){return n.x>t.left&&n.x<t.right&&n.y>t.top&&n.y<t.bottom},posFromEvent:function(n){if(n.type.startsWith("touch")){if(n.touches.length==1)return{x:n.touches[0].pageX,y:n.touches[0].pageY};if(n.touches.length==2){var i={x:n.touches[0].pageX,y:n.touches[0].pageY},r={x:n.touches[1].pageX,y:n.touches[1].pageY},u=t.math.Midpoint2D(i,r);return{x:u.x,y:u.y,dist:t.math.Dist2D(i,r)}}}else return{x:n.pageX,y:n.pageY}},animateRight:function(n){var i=t.flip_animator,r=t.pager.constant;i.dragged.addClass("animate");i.revealed.addClass("wait");t.overlays.setHidden(!0);t.pager.current_mode==r.DOUBLE||t.pager.current_mode==r.DOUBLE_REVERSE?(t.pager.showPage(t.pager.current_page_left+2)?i.dragged.removeClass("hidden"):i.dragged.addClass("hidden"),t.pager.showPage(t.pager.current_page_right+2)?i.revealed.removeClass("hidden"):i.revealed.addClass("hidden"),i.fullhidden.addClass("hidden"),i.dragged.setStyle("left","auto"),i.revealed.setStyle("left","auto"),i.revealed.setStyle("right",t.pager.current_padding+"px"),i.revealed.find(".wrapper").setStyle("left","auto"),i.revealed.find(".wrapper").setStyle("width",i.size.width+"px"),i.dragged.find(".wrapper").setStyle("right","auto"),i.dragged.find(".wrapper").setStyle("width",i.size.width+"px"),i.hidden.find(".wrapper").setStyle("right","auto"),i.hidden.find(".wrapper").setStyle("width",i.size.width+"px"),i.dragged.setStyle("right",Math.min(t.pager.current_padding+n/2,i.size.width+t.pager.current_padding)+"px"),i.dragged.setStyle("width",Math.min(n/2,i.size.width)+"px"),i.hidden.setStyle("width",Math.max(0,i.size.width-n)+"px"),i.revealed.setStyle("width",Math.min(n/2,i.size.width)+"px")):(t.pager.showPage(t.pager.current_page+1)&&i.revealed.removeClass("hidden"),i.dragged.find(".wrapper").setStyle("left","auto"),i.dragged.find(".wrapper").setStyle("width",i.size.width+"px"),i.dragged.setStyle("right",Math.min(t.pager.current_padding+n,i.size.width+t.pager.current_padding)+"px"),i.dragged.setStyle("width",Math.max(i.size.width-n,0)+"px"))},animateLeft:function(n){var i=t.flip_animator,r=t.pager.constant;i.dragged.addClass("animate");i.revealed.addClass("wait");t.overlays.setHidden(!0);t.pager.current_mode==r.DOUBLE||t.pager.current_mode==r.DOUBLE_REVERSE?(t.pager.showPage(t.pager.current_page_left-2)?i.revealed.removeClass("hidden"):i.revealed.addClass("hidden"),t.pager.showPage(t.pager.current_page_right-2)?i.dragged.removeClass("hidden"):i.dragged.addClass("hidden"),i.dragged.setStyle("right","auto"),i.dragged.find(".wrapper").setStyle("left","auto"),i.dragged.find(".wrapper").setStyle("width",i.size.width+"px"),i.revealed.find(".wrapper").setStyle("right","auto"),i.revealed.find(".wrapper").setStyle("width",i.size.width+"px"),i.hidden.find(".wrapper").setStyle("left","auto"),i.hidden.find(".wrapper").setStyle("width",i.size.width+"px"),i.revealed.setStyle("right","auto"),i.revealed.setStyle("left",t.pager.current_padding+"px"),i.dragged.setStyle("left",Math.min(t.pager.current_padding+n/2,i.size.width+t.pager.current_padding)+"px"),i.dragged.setStyle("width",Math.min(n/2,i.size.width)+"px"),i.hidden.setStyle("width",Math.max(0,i.size.width-n)+"px"),i.revealed.setStyle("width",Math.min(n/2,i.size.width)+"px")):(t.pager.showPage(t.pager.current_page-1)?i.revealed.removeClass("hidden"):i.revealed.addClass("hidden"),i.dragged.setStyle("right",t.pager.current_padding+"px"),i.dragged.find(".wrapper").setStyle("left","auto"),i.dragged.find(".wrapper").setStyle("width",i.size.width+"px"),i.revealed.find(".wrapper").setStyle("left","auto"),i.revealed.find(".wrapper").setStyle("width",i.size.width+"px"),i.dragged.setStyle("left",Math.min(t.pager.current_padding+n,i.size.width+t.pager.current_padding)+"px"),i.dragged.setStyle("width",Math.max(0,i.size.width-n)+"px"),i.revealed.setStyle("width",Math.min(n,i.size.width)+"px"))},animateRightTo:function(i,r,u){var f=t.flip_animator,l=t.pager.constant,e=0,o=30,s=n.requestAnimationFrame||n.mozRequestAnimationFrame||n.webkitRequestAnimationFrame||n.msRequestAnimationFrame,h=n.cancelAnimationFrame||n.mozCancelAnimationFrame,c=function(){f.animateRight(t.math.easing.easeInOutQuad(e++,i,r-i,o));e<o?f.animationTimeout=s(c):t.is.function(u)&&(u(),h(f.animationTimeout))};h(f.animationTimeout);f.animationTimeout=s(c)},animateLeftTo:function(i,r,u){var f=t.flip_animator,l=t.pager.constant,e=0,o=30,s=n.requestAnimationFrame||n.mozRequestAnimationFrame||n.webkitRequestAnimationFrame||n.msRequestAnimationFrame,h=n.cancelAnimationFrame||n.mozCancelAnimationFrame,c=function(){f.animateLeft(t.math.easing.easeInOutQuad(e++,i,r-i,o));e<o?f.animationTimeout=s(c):t.is.function(u)&&(u(),h(f.animationTimeout))};h(f.animationTimeout);f.animationTimeout=s(c)},listenerStart:function(n){var i=t.flip_animator,o=t.pager.constant;if(!i.lockAnimation&&!t.pager.touchBlocked&&t.pager.current_animation==o.FLIP)if(t.pager.current_mode==o.DOUBLE||t.pager.current_mode==o.DOUBLE_REVERSE){var u=t.pager.holders[o.CUR_LEFT][0].getBoundingClientRect(),f=t.pager.holders[o.CUR_RIGHT][0].getBoundingClientRect(),s={top:u.top,left:u.left,right:u.left+u.width*.1,bottom:u.bottom},h={top:f.top,left:f.right-f.width*.1,right:f.right,bottom:f.bottom},e=i.posFromEvent(n);i.intersects(e,h)&&t.pager.showPage(t.pager.current_page_left+2)?(i.size={width:u.width||f.width,height:u.height||f.height},i.target=t.pager.page_container[0].getBoundingClientRect(),i.target={top:i.target.top+t.pager.current_padding,left:i.target.left+t.pager.current_padding,right:i.target.right-t.pager.current_padding,bottom:i.target.bottom-t.pager.current_padding},i.moveStart=e,t.pager.paging_handled_by_animator=!0,i.startDragRight()):i.intersects(e,s)&&t.pager.showPage(t.pager.current_page_right-2)&&(i.size={width:u.width||f.width,height:u.height||f.height},i.target=t.pager.page_container[0].getBoundingClientRect(),i.target={top:i.target.top+t.pager.current_padding,left:i.target.left+t.pager.current_padding,right:i.target.right-t.pager.current_padding,bottom:i.target.bottom-t.pager.current_padding},i.moveStart=e,t.pager.paging_handled_by_animator=!0,i.startDragLeft())}else{var r=t.pager.holders[o.CUR][0].getBoundingClientRect(),s={top:r.top,left:r.left,right:r.left+r.width*.1,bottom:r.bottom},h={top:r.top,left:r.right-r.width*.1,right:r.right,bottom:r.bottom},e=i.posFromEvent(n);i.size={width:r.width,height:r.height};i.target=t.pager.page_container[0].getBoundingClientRect();i.target={top:i.target.top+t.pager.current_padding,left:i.target.left+t.pager.current_padding,right:i.target.right-t.pager.current_padding,bottom:i.target.bottom-t.pager.current_padding};i.moveStart=e;i.intersects(e,h)&&t.pager.showPage(t.pager.current_page+1)?(t.pager.paging_handled_by_animator=!0,i.startDragRight()):i.intersects(e,s)&&t.pager.showPage(t.pager.current_page-1)&&(t.pager.paging_handled_by_animator=!0,i.startDragLeft())}},listenerMove:function(n){var i=t.flip_animator,f=t.pager.constant,r,u;!i.lockAnimation&&i.dragging&&(r=i.posFromEvent(n),i.last=r,i.direction=="right"?(u=Math.abs(i.target.right-r.x),i.animateRight(u)):i.direction=="left"&&(u=Math.abs(i.target.left-r.x),i.animateLeft(u)))},listenerEnd:function(){var n=t.flip_animator,e=t.pager.constant,f,r;if(!n.lockAnimation&&n.dragging)if(t.reader.playPageSound(),f=n.last,r=function(){n.dragged.removeClass("animate");n.revealed.removeClass("wait");n.dragged.find(".wrapper").setAttr("style","");n.revealed.find(".wrapper").setAttr("style","");n.hidden.find(".wrapper").setAttr("style","");n.dragged.find(".loader").setAttr("style","");n.revealed.find(".loader").setAttr("style","");t.pager.paging_handled_by_animator=!1;n.last=null;n.lockAnimation=!1;t.overlays.setHidden(!1)},n.direction=="right"){var i=f!=null?Math.abs(n.target.right-f.x):0,u=t.pager.current_mode==e.DOUBLE||t.pager.current_mode==e.DOUBLE_REVERSE?n.size.width*2:n.size.width,o=u/10;i<u?i>=o?n.animateRightTo(i,u,function(){t.pager.goForward(null,function(){r()})}):n.animateRightTo(i,0,function(){r()}):t.pager.goForward(null,function(){r()})}else if(n.direction=="left"){var i=f!=null?Math.abs(n.target.left-f.x):0,u=t.pager.current_mode==e.DOUBLE||t.pager.current_mode==e.DOUBLE_REVERSE?n.size.width*2:n.size.width,o=u/10;i<u?i>=o?n.animateLeftTo(i,u,function(){t.pager.goBack(function(){r()})}):n.animateLeftTo(i,0,function(){r()}):t.pager.goBack(function(){r()})}n.dragging=!1},lockAnimation:!1,doFullAnimationNext:function(n){var i=t.flip_animator,r=t.pager.constant,h,o,u,f,e,s;!i.lockAnimation&&t.pager.can_go_forward&&(i.lockAnimation=!0,t.reader.playPageSound(),h=i.last,o=function(){i.dragged.removeClass("animate");i.revealed.removeClass("wait");i.dragged.find(".wrapper").setAttr("style","");i.revealed.find(".wrapper").setAttr("style","");i.hidden.find(".wrapper").setAttr("style","");i.dragged.find(".loader").setAttr("style","");i.revealed.find(".loader").setAttr("style","");n&&t.is.function(n)&&n();i.lockAnimation=!1;t.pager.paging_handled_by_animator=!1;i.last=null;t.overlays.setHidden(!1)},t.pager.current_mode==r.DOUBLE||t.pager.current_mode==r.DOUBLE_REVERSE?(u=t.pager.holders[r.CUR_LEFT][0].getBoundingClientRect(),f=t.pager.holders[r.CUR_RIGHT][0].getBoundingClientRect(),i.size={width:u.width||f.width,height:u.height||f.height}):(e=t.pager.holders[r.CUR][0].getBoundingClientRect(),i.size={width:e.width,height:e.height}),i.target=t.pager.page_container[0].getBoundingClientRect(),i.target={top:i.target.top+t.pager.current_padding,left:i.target.left+t.pager.current_padding,right:i.target.right-t.pager.current_padding,bottom:i.target.bottom-t.pager.current_padding},s=t.pager.current_mode==r.DOUBLE||t.pager.current_mode==r.DOUBLE_REVERSE?i.size.width*2:i.size.width,t.pager.current_mode==r.DOUBLE||t.pager.current_mode==r.DOUBLE_REVERSE?(i.dragged=t.pager.holders[r.NEXT_LEFT],i.revealed=t.pager.holders[r.NEXT_RIGHT],i.hidden=t.pager.holders[r.CUR_RIGHT],i.fullhidden=t.e([t.pager.holders[r.PREV_LEFT],t.pager.holders[r.PREV_RIGHT]]),t.pager.showPage(t.pager.current_page_left+2)&&i.dragged.removeClass("hidden"),t.pager.showPage(t.pager.current_page_right+2)&&i.revealed.removeClass("hidden"),i.fullhidden.addClass("hidden")):(i.dragged=t.pager.holders[r.CUR],i.revealed=t.pager.holders[r.NEXT],i.hidden=t.e(),i.fullhidden=t.pager.holders[r.PREV],t.pager.showPage(t.pager.current_page+1)&&i.revealed.removeClass("hidden")),i.dragged.addClass("animate"),i.revealed.addClass("wait"),t.pager.current_mode==r.DOUBLE||t.pager.current_mode==r.DOUBLE_REVERSE?(i.dragged.setStyle("left","auto"),i.dragged.setStyle("right",t.pager.current_padding+"px"),i.dragged.setStyle("width","0px"),i.revealed.setStyle("left","auto"),i.revealed.setStyle("right",t.pager.current_padding+"px"),i.revealed.setStyle("width","0px"),i.revealed.find(".wrapper").setStyle("left","auto"),i.revealed.find(".wrapper").setStyle("width",i.size.width+"px")):(i.dragged.setStyle("right",t.pager.current_padding+"px"),i.dragged.setStyle("width",i.size.width),i.dragged.find(".wrapper").setStyle("left","auto"),i.dragged.find(".wrapper").setStyle("width",i.size.width+"px")),i.direction="right",i.animateRightTo(0,s,function(){t.pager.goForward(null,function(){o()})}))},doFullAnimationPrev:function(n){var i=t.flip_animator,r=t.pager.constant,h,o,u,f,e,s;!i.lockAnimation&&t.pager.can_go_back&&(i.lockAnimation=!0,t.reader.playPageSound(),h=i.last,o=function(){i.dragged.removeClass("animate");i.revealed.removeClass("wait");i.dragged.find(".wrapper").setAttr("style","");i.revealed.find(".wrapper").setAttr("style","");i.hidden.find(".wrapper").setAttr("style","");i.dragged.find(".loader").setAttr("style","");i.revealed.find(".loader").setAttr("style","");n&&t.is.function(n)&&n();i.lockAnimation=!1;t.pager.paging_handled_by_animator=!1;i.last=null;t.overlays.setHidden(!1)},t.pager.current_mode==r.DOUBLE||t.pager.current_mode==r.DOUBLE_REVERSE?(u=t.pager.holders[r.CUR_LEFT][0].getBoundingClientRect(),f=t.pager.holders[r.CUR_RIGHT][0].getBoundingClientRect(),i.size={width:u.width||f.width,height:u.height||f.height}):(e=t.pager.holders[r.CUR][0].getBoundingClientRect(),i.size={width:e.width,height:e.height}),i.target=t.pager.page_container[0].getBoundingClientRect(),i.target={top:i.target.top+t.pager.current_padding,left:i.target.left+t.pager.current_padding,right:i.target.right-t.pager.current_padding,bottom:i.target.bottom-t.pager.current_padding},s=t.pager.current_mode==r.DOUBLE||t.pager.current_mode==r.DOUBLE_REVERSE?i.size.width*2:i.size.width,t.pager.current_mode==r.DOUBLE||t.pager.current_mode==r.DOUBLE_REVERSE?(i.dragged=t.pager.holders[r.PREV_RIGHT],i.revealed=t.pager.holders[r.PREV_LEFT],i.hidden=t.pager.holders[r.CUR_LEFT],i.fullhidden=t.e([t.pager.holders[r.NEXT_LEFT],t.pager.holders[r.NEXT_RIGHT]]),t.pager.showPage(t.pager.current_page_left-2)&&i.revealed.removeClass("hidden"),t.pager.showPage(t.pager.current_page_right-2)&&i.dragged.removeClass("hidden"),i.fullhidden.addClass("hidden")):(i.dragged=t.pager.holders[r.CUR],i.revealed=t.pager.holders[r.PREV],i.hidden=t.e(),i.fullhidden=t.pager.holders[r.NEXT],t.pager.showPage(t.pager.current_page-1)&&i.revealed.removeClass("hidden"),i.dragged.removeClass("hidden")),i.dragged.addClass("animate"),i.revealed.addClass("wait"),t.pager.current_mode==r.DOUBLE||t.pager.current_mode==r.DOUBLE_REVERSE?(i.dragged.setStyle("right","auto"),i.dragged.setStyle("left",t.pager.current_padding+"px"),i.dragged.setStyle("width","0px"),i.dragged.find(".wrapper").setStyle("left","auto"),i.dragged.find(".wrapper").setStyle("width",i.size.width+"px"),i.revealed.setStyle("right","auto"),i.revealed.setStyle("left",t.pager.current_padding+"px"),i.revealed.setStyle("width","0px")):(i.dragged.setStyle("right",t.pager.current_padding+"px"),i.dragged.find(".wrapper").setStyle("left","auto"),i.dragged.find(".wrapper").setStyle("width",i.size.width+"px"),i.revealed.find(".wrapper").setStyle("left","auto"),i.revealed.find(".wrapper").setStyle("width",i.size.width+"px")),i.direction="left",i.animateLeftTo(0,s,function(){t.pager.goBack(null,function(){o()})}))},startDragRight:function(){var i=t.flip_animator,r=t.pager.constant,f=n.requestAnimationFrame||n.mozRequestAnimationFrame||n.webkitRequestAnimationFrame||n.msRequestAnimationFrame,u=n.cancelAnimationFrame||n.mozCancelAnimationFrame;i.dragging=!0;u(i.animationTimeout);t.pager.current_mode==r.DOUBLE||t.pager.current_mode==r.DOUBLE_REVERSE?(i.dragged=t.pager.holders[r.NEXT_LEFT],i.revealed=t.pager.holders[r.NEXT_RIGHT],i.hidden=t.pager.holders[r.CUR_RIGHT],i.fullhidden=t.e([t.pager.holders[r.PREV_LEFT],t.pager.holders[r.PREV_RIGHT]]),t.pager.showPage(t.pager.current_page_left+2)&&i.dragged.removeClass("hidden"),t.pager.showPage(t.pager.current_page_right+2)&&i.revealed.removeClass("hidden"),i.fullhidden.addClass("hidden")):(i.dragged=t.pager.holders[r.CUR],i.revealed=t.pager.holders[r.NEXT],i.hidden=t.e(),i.fullhidden=t.pager.holders[r.PREV],t.pager.showPage(t.pager.current_page+1)&&i.revealed.removeClass("hidden"));i.dragged.addClass("animate");i.revealed.addClass("wait");t.pager.current_mode==r.DOUBLE||t.pager.current_mode==r.DOUBLE_REVERSE?(i.dragged.setStyle("left","auto"),i.dragged.setStyle("right",t.pager.current_padding+"px"),i.dragged.setStyle("width","0px"),i.revealed.setStyle("left","auto"),i.revealed.setStyle("right",t.pager.current_padding+"px"),i.revealed.setStyle("width","0px"),i.revealed.find(".wrapper").setStyle("left","auto"),i.revealed.find(".wrapper").setStyle("width",i.size.width+"px")):(i.dragged.setStyle("right",t.pager.current_padding+"px"),i.dragged.setStyle("width",i.size.width),i.dragged.find(".wrapper").setStyle("left","auto"),i.dragged.find(".wrapper").setStyle("width",i.size.width+"px"));i.direction="right"},startDragLeft:function(){var i=t.flip_animator,r=t.pager.constant,f=n.requestAnimationFrame||n.mozRequestAnimationFrame||n.webkitRequestAnimationFrame||n.msRequestAnimationFrame,u=n.cancelAnimationFrame||n.mozCancelAnimationFrame;i.dragging=!0;u(i.animationTimeout);t.pager.current_mode==r.DOUBLE||t.pager.current_mode==r.DOUBLE_REVERSE?(i.dragged=t.pager.holders[r.PREV_RIGHT],i.revealed=t.pager.holders[r.PREV_LEFT],i.hidden=t.pager.holders[r.CUR_LEFT],i.fullhidden=t.e([t.pager.holders[r.NEXT_LEFT],t.pager.holders[r.NEXT_RIGHT]]),t.pager.showPage(t.pager.current_page_left-2)&&i.revealed.removeClass("hidden"),t.pager.showPage(t.pager.current_page_right-2)&&i.dragged.removeClass("hidden"),i.fullhidden.addClass("hidden")):(i.dragged=t.pager.holders[r.CUR],i.revealed=t.pager.holders[r.PREV],i.hidden=t.e(),i.fullhidden=t.pager.holders[r.NEXT],t.pager.showPage(t.pager.current_page-1)&&i.revealed.removeClass("hidden"),i.dragged.removeClass("hidden"));i.dragged.addClass("animate");i.revealed.addClass("wait");t.pager.current_mode==r.DOUBLE||t.pager.current_mode==r.DOUBLE_REVERSE?(i.dragged.setStyle("right","auto"),i.dragged.setStyle("left",t.pager.current_padding+"px"),i.dragged.setStyle("width","0px"),i.dragged.find(".wrapper").setStyle("left","auto"),i.dragged.find(".wrapper").setStyle("width",i.size.width+"px"),i.revealed.setStyle("right","auto"),i.revealed.setStyle("left",t.pager.current_padding+"px"),i.revealed.setStyle("width","0px")):(i.dragged.setStyle("right",t.pager.current_padding+"px"),i.dragged.find(".wrapper").setStyle("left","auto"),i.dragged.find(".wrapper").setStyle("width",i.size.width+"px"),i.revealed.find(".wrapper").setStyle("left","auto"),i.revealed.find(".wrapper").setStyle("width",i.size.width+"px"));i.direction="left"}},overlays:{elements:[],objects:[],container:null,lastRenderPage:-1,lastRenderZoom:-1,lastRenderMode:-1,init:function(){this.container=t.e("#reader-container .overlayer");for(var n=t.reader.container.find(".overlay"),i=0,r=n.length;i<r;i++)this.parse(n[i]);n.remove()},setHidden:function(n){var i=t.overlays;n?i.container.addClass("hidden"):i.container.removeClass("hidden")},parse:function(n){var i=t.e(n),r={html:i.getHtml().trim(),display:i.getAttr("data-display"),type:i.getAttr("data-type"),x:parseInt(i.getAttr("data-x")),y:parseInt(i.getAttr("data-y")),width:parseInt(i.getAttr("data-width")),height:parseInt(i.getAttr("data-height")),page:parseInt(i.getAttr("data-page")),openWidth:parseInt(i.getAttr("data-open-width")),openHeight:parseInt(i.getAttr("data-open-height")),icon:i.getAttr("data-icon")};this.elements.push(r)},render:function(){var n=t.overlays,e=0,c=n.elements.length,f=t.pager.constant,r=t.pager,o,s,h,i,u;if(n.lastRenderMode!=r.current_mode||n.lastRenderPage!=r.current_page||n.lastRenderZoom!=r.current_zoom)for(n.lastRenderMode=r.current_mode,n.lastRenderPage=r.current_page,n.lastRenderZoom=r.current_zoom,n.prepare(),n.objects=[],t.pager.current_mode==f.SINGLE?o=n.container.find(".page"):t.pager.current_mode==f.DOUBLE&&(s=n.container.find(".left"),h=n.container.find(".right"));e<c;e++)i=n.elements[e],t.pager.current_mode==f.SINGLE?i.page==t.pager.current_page&&(u=n.make(i).appendTo(o)):t.pager.current_mode==f.DOUBLE&&(i.page==t.pager.current_page_left?u=n.make(i).appendTo(s):i.page==t.pager.current_page_right&&(u=n.make(i).appendTo(h))),u&&n.objects.push(u)},getAvailableSpace:function(){var n=t.math.rect(t.pager.content_container[0].scrollTop,t.pager.content_container[0].scrollLeft,t.reader.container.getHeight()+t.pager.content_container[0].scrollTop,t.reader.container.getWidth()+t.pager.content_container[0].scrollLeft),i=!1,r=!1,u=!1,f=!1;return t.e("#reader-container .controls .top, #reader-container .controls .topleft .horizontal, #reader-container .controls .topright .horizontal").children().length>0&&(i=!0),t.e("#reader-container .controls .left, #reader-container .controls .topleft .vertical, #reader-container .controls .bottomleft .vertical").children().length>0&&(r=!0),t.e("#reader-container .controls .bottom, #reader-container .controls .bottomleft .horizontal, #reader-container .controls .bottomright .horizontal").children().length>0&&(f=!0),t.e("#reader-container .controls .right, #reader-container .controls .topright .vertical, #reader-container .controls .bottomright .vertical").children().length>0&&(u=!0),i&&(n.top+=t.e("#reader-container .controls .top").getHeight()),r&&(n.left+=t.e("#reader-container .controls .left").getWidth()),f&&(n.bottom-=t.e("#reader-container .controls .bottom").getHeight()),u&&(n.right-=t.e("#reader-container .controls .right").getWidth()),t.reader.overview.isOpen&&(t.reader.settings.overview_direction=="top"?n.top+=t.reader.settings.overview_size:t.reader.settings.overview_direction=="bottom"?n.bottom-=t.reader.settings.overview_size:t.reader.settings.overview_direction=="right"?n.right-=t.reader.settings.overview_size:t.reader.settings.overview_direction=="left"&&(n.left+=t.reader.settings.overview_size)),n},prepare:function(){var n=t.overlays,f=t.pager.constant,i,r,u;t.pager.touchBlocked=!1;n.container.children().remove();n.container.setStyle("padding",t.pager.current_padding+"px");t.pager.current_mode==f.SINGLE?(i=t.pager.getPageSize(t.pager.current_page),t.e("<div>",{"class":"page",width:i.width+"px",height:i.height+"px"}).appendTo(n.container)):t.pager.current_mode==f.DOUBLE&&(r=t.pager.getPageSize(t.pager.current_page_left),u=t.pager.getPageSize(t.pager.current_page_right),t.e("<div>",{"class":"page left",width:r.width+"px",height:r.height+"px"}).appendTo(n.container),t.e("<div>",{"class":"page right",width:u.width+"px",height:u.height+"px"}).appendTo(n.container))},make_audio_controls:function(n){var i=n[0],r=t.e("<div>",{"class":"controller flex horizontal"}),u=!1,f=t.e("<div>",{"class":"icon",html:"play_arrow"}).appendTo(r),e=t.reader.make_slider({dark:!0,discrete:!0,min:0,max:100,value:50,sigfigs:0,callback:function(n){try{i.volume=n/100}catch(t){}}}).appendTo(r);f.on("click tap",function(){if(u){f.setHtml("play_arrow");try{i.pause()}catch(n){}u=!1}else{f.setHtml("pause");try{i.play()}catch(n){t.reader.makeMessage(t.locale.getString("ERROR_TITLE"),t.locale.getString("UNSUPPORTED_AUDIO")).appendTo(t.reader.container)}u=!0}});try{i.volume=.5}catch(o){}return r.extend({close:function(){f.setHtml("play_arrow");try{i.pause();u=!1}catch(n){}}}),r},make_video_controls:function(n,i){var e=t.random.guid();t.e(n.getParents()[0]).setAttr("id",e);var r=n[0],f=t.e("<div>",{"class":"controller flex horizontal"}),o=!1,c=t.e("<div>",{"class":"icon",html:"play_arrow"}).appendTo(f),s=t.reader.make_slider({dark:!0,discrete:!1,buffering:!0,buffer:0,min:0,max:100,value:1,callback:function(n,t){if(u)u.player.onSeek(n,t)}},e).appendTo(f),a=t.e("<div>",{"class":"icon",html:"volume_up"}).appendTo(f),h=t.e("<div>",{"class":"hidden_menu flex vertical"}).appendTo(f),l=t.e("<div>",{"class":"icon",html:"fullscreen"}).appendTo(f),v=t.reader.make_slider({dark:!0,discrete:!0,vertical:!0,min:0,max:100,value:50,sigfigs:0,callback:function(n){try{r.volume=n/100}catch(t){}}},e).appendTo(h),u={player:{playpause:function(){o?u.player.pause():u.player.play()},pause:function(){try{r.pause()}catch(n){}o=!1},play:function(){try{r.play()}catch(n){t.reader.makeMessage(t.locale.getString("ERROR_TITLE"),t.locale.getString("UNSUPPORTED_VIDEO")).appendTo(t.reader.container)}},onTime:function(){s.slider.value=r.currentTime;s.slider.max=r.duration;s.slider.update(!0)},onSeek:function(n,t){if(t)try{r.currentTime=n}catch(i){}},onProgress:function(){r.buffered.length>0&&s.slider.setBuffer(t.math.Percentage.XofY(r.buffered.end(0),r.duration))},onState:function(){r.paused?(c.setHtml("play_arrow"),o=!1):(c.setHtml("pause"),o=!0)},onMeta:function(){i&&t.is.function(i)&&i()},onFullscreen:function(n,i){t.e(i).getAttr("id")==e&&(n=="exit"?l.setHtml("fullscreen_enter"):l.setHtml("fullscreen_exit"))}}};n.on("timeupdate",u.player.onTime);n.on("progress",u.player.onProgress);n.on("loadedmetadata",u.player.onMeta);n.on("pause play ended abort",u.player.onState);l.on("click tap",function(){t.fullscreen.isFullscreen?t.fullscreen.exit():t.fullscreen.enter(n.getParents()[0])});t.subscribe("fullscreen",u.player.onFullscreen);a.on("mouseenter",function(){h.toggleClass("open")});h.on("mouseleave",function(){h.removeClass("open")});c.on("click tap",u.player.playpause);try{r.volume=.5}catch(p){}return f.extend(u),f},make_iframe_controls:function(n){var r=n[0],i=t.e("<div>",{"class":"navigator flex horizontal"}),u=t.e("<div>").appendTo(i),f=t.e("<div>",{"class":"icon",html:"arrow_back"}).appendTo(i),e=t.e("<div>",{"class":"icon",html:"arrow_forward"}).appendTo(i),o=t.e("<div>",{"class":"icon",html:"refresh"}).appendTo(i);return r.readystatechange=function(){},i},make_gallery:function(n){for(var i,o=t.random.guid(),r=t.e("<div>",{"class":"container",id:o}),h=t.e("<div>",{"class":"navigation icon left",html:"keyboard_arrow_left"}).appendTo(r),c=t.e("<div>",{"class":"navigation icon right",html:"keyboard_arrow_right"}).appendTo(r),e=t.e("<div>",{"class":"fullscreen icon",html:"fullscreen_enter"}).appendTo(r),l=t.e("<div>",{"class":"dots"}).appendTo(r),u=[],f=[],s=0;s<n.length;s++)u.push(t.reader.stageLoader().appendTo(r)),f.push(t.e("<div>",{"class":"dot"}).appendTo(l));i={gallery:{hasBeenStarted:!1,index:0,max:n.length-1,start:function(){var t,r;if(!i.gallery.hasBeenStarted){for(i.gallery.hasBeenStarted=!0,t=0;t<n.length;t++)r=n[t],u[t].load([r]);u[0].addClass("appear");f[0].addClass("active")}},next:function(){var n=i.gallery,r=n.index+1;r>n.max&&(r=0);t.e(u).removeClass("vanish appear left right");u[n.index].addClass("vanish");u[r].addClass("appear right");n.index=r;t.e(f).removeClass("active");f[n.index].addClass("active")},prev:function(){var n=i.gallery,r=n.index-1;r<=0&&(r=n.max);t.e(u).removeClass("vanish appear left right");u[n.index].addClass("vanish");u[r].addClass("appear left");n.index=r;t.e(f).removeClass("active");f[n.index].addClass("active")},onFullscreen:function(n,i){t.e(i).getAttr("id")==o&&(n=="exit"?e.setHtml("fullscreen_enter"):e.setHtml("fullscreen_exit"))},fullscreen:function(){t.fullscreen.isFullscreen?t.fullscreen.exit():t.fullscreen.enter(r[0])}}};t.TouchHandler(r,{propagate:!1,priority:!0,onSwipeLeft:i.gallery.next,onSwipeRight:i.gallery.prev});t.subscribe("fullscreen",i.gallery.onFullscreen);h.on("click tap",i.gallery.prev);c.on("click tap",i.gallery.next);e.on("click tap",i.gallery.fullscreen);return r.extend(i),r},make:function(i){var r=t.e("<div>",{"class":"overlay visible "+i.type}),u=t.pager.current_zoom,it=t.e("<div>",{"class":"dimmer"}).appendTo(r),f=t.e("<div>",{"class":"icon"}).appendTo(r),nt=t.e("<div>",{"class":"controls flex horizontal reverse"}).appendTo(r),l=t.e("<div>",{"class":"content"}).appendTo(r),e=t.e("<div>",{"class":"wrap"}).appendTo(l),b=!1,a=!1,tt=t.e("<div>",{"class":"icon close",html:"close"}).appendTo(nt),k,p,d,h,y;i.display=="area"?(r.addClass("area"),r.setStyle("width",i.width*u+"px"),r.setStyle("height",i.height*u+"px")):r.addClass("pin");r.setStyle("left",i.x*u+"px");r.setStyle("top",i.y*u+"px");switch(i.type){case"html":f.setHtml("code");break;case"image":f.setHtml("image");break;case"gallery":f.setHtml("photo_library");break;case"video":f.setHtml("video_library");break;case"audio":f.setHtml("library_music");break;case"link":f.setHtml("link");break;case"page":f.setHtml("input");break;case"embed":f.setHtml("web")}i.icon&&f.setHtml(i.icon);switch(i.type){case"html":e.setHtml(i.html);break;case"image":h=t.e(i.html);t.e("<img>",{src:h.getAttr("src"),alt:t.locale.getString("IMG_ALT")}).appendTo(e);b=!0;break;case"gallery":k=t.e(i.html);p=[];k.each(function(){p.push(t.e(this).getAttr("src"))});d=t.overlays.make_gallery(p).appendTo(e);i.openWidth=isNaN(i.openWidth)?1e4:i.openWidth;i.openHeight=isNaN(i.openHeight)?1e4:i.openHeight;break;case"audio":var w=t.e("<audio>"),k=t.e(i.html).appendTo(w),c=t.overlays.make_audio_controls(w);w.appendTo(e);c.appendTo(e);break;case"video":var v=t.e("<div>",{"class":"player"}),rt=t.e("<div>",{"class":"shield"}).appendTo(v),s=t.e("<video>").appendTo(v),k=t.e(i.html).appendTo(s),c=t.overlays.make_video_controls(s,function(){i.openWidth=isNaN(i.openWidth)?Math.max(320,s[0].videoWidth):i.openWidth;i.openHeight=isNaN(i.openHeight)?Math.max(240,s[0].videoHeight):i.openHeight;o.adjustSize(i.openWidth,i.openHeight)});v.appendTo(e);c.appendTo(v);i.openWidth=isNaN(i.openWidth)?Math.max(320,s[0].videoWidth):i.openWidth;i.openHeight=isNaN(i.openHeight)?Math.max(240,s[0].videoHeight):i.openHeight;t.reader.container.on("keyup",function(n){r.hasClass("open")&&(n.keyCode==32||n.keyCode==75)&&(n&&n.preventDefault&&n.preventDefault(),n&&n.stopPropagation&&n.stopPropagation(),c.player.playpause())});break;case"link":case"page":h=t.e(i.html);y=h.getAttr("src");break;case"embed":var h=t.e(i.html),y=h.getAttr("src"),g=t.e("<iframe>").appendTo(e);i.openWidth=isNaN(i.openWidth)?1e4:i.openWidth;i.openHeight=isNaN(i.openHeight)?1e4:i.openHeight}var o={adjustSize:function(n,f){if(r.hasClass("open")){for(var s=r.getRelativeXY(".content"),h=Math.max(n+16,200),c=Math.max(f+8+32+8,80),l=t.math.rect(s.y,s.x,s.y+c,s.x+h),e=t.math.rect(s.y,s.x,s.y+c,s.x+h),o=t.overlays.getAvailableSpace(),v=i.y*u,y=i.x*u,p=0;!o.contains(e);)if(e.height>o.height&&(a=!0,e.height=o.height),e.width>o.width&&(a=!0,e.width=o.width),e.top<o.top&&e.moveTopTo(o.top),e.left<o.left&&e.moveLeftTo(o.left),e.bottom>o.bottom&&e.moveTopBy(o.bottom-e.bottom),e.right>o.right&&e.moveLeftBy(o.right-e.right),p++>10)break;v+=e.top-l.top;y+=e.left-l.left;h=e.width;c=e.height;a?r.addClass("overflow"):r.removeClass("overflow");r.setStyle("width",h+"px");r.setStyle("height",c+"px");r.setStyle("top",v+"px");r.setStyle("left",y+"px")}},open:function(u){if(u&&u.preventDefault&&u.preventDefault(),u&&u.stopPropagation&&u.stopPropagation(),!r.hasClass("open")){t.overlays.closeAll();switch(i.type){case"link":n.open(y);break;case"page":t.pager.goToPage(t.pager.current_page=parseInt(y));break;case"embed":g.getAttr("src")||g.setAttr("src",y);default:t.pager.touchBlocked=!0;i.type=="gallery"&&d.gallery.start();var f=isNaN(i.openWidth)?e.getWidth():i.openWidth,s=isNaN(i.openHeight)?e.getHeight():i.openHeight;r.addClass("open");o.adjustSize(f,s)}}},close:function(n){n&&n.preventDefault&&n.preventDefault();n&&n.stopPropagation&&n.stopPropagation();r.hasClass("open")&&(r.removeClass("open"),t.pager.touchBlocked=!1,i.type=="audio"&&c.close(),i.type=="video"&&c.player.pause(),i.display=="area"?(r.setStyle("width",i.width*u+"px"),r.setStyle("height",i.height*u+"px")):(r.setStyle("width",""),r.setStyle("height","")),r.setStyle("left",i.x*u+"px"),r.setStyle("top",i.y*u+"px"))},onDrag:function(n){r.hasClass("open")&&a&&(l[0].scrollLeft+=n.x,l[0].scrollTop+=n.y)}};b&&t.TouchHandler(l,{propagate:!1,priority:!0,onDrag:o.onDrag,onWheelStart:o.onWheelStart,onWheel:o.onWheel,onWheelEnd:o.onWheelEnd});r.on("click tap",o.open);tt.on("click tap",o.close);return r.extend(o),r},closeAll:function(){for(var n=0,i=t.overlays.objects.length;n<i;n++)t.overlays.objects[n].close()}},pager:{pages:null,get page_count(){return Object.keys(this.pages).length},current_script:null,current_mode:1,current_mode_manual:!1,current_renderer:1,current_renderer_manual:!1,current_zoom:1,current_autozoom:!0,current_padding:20,current_controls:!1,current_controls_floating:!1,current_animation:0,current_animator:null,holders:[],loaders:[],page_container:null,content_container:null,pages_uniform:!0,pdf_exists:!1,pdf_checked:!1,pdf_checking:!1,pdf_enabled:!1,pdf_preparing:!1,pdf_loaded:!1,pdf_loaded_load:!1,pdf_loaded_progess:!1,pdf_rendering_slow:!1,pdf_last_rendertimes:[],pdf_last_rendertime_index:0,pdf_last_rendertime_max:10,is_mobile:!1,touchBlocked:!1,get pdf_average_rendertimes(){for(var n=0,t=0,i=this.pdf_last_rendertimes.length;n<i;n++)t+=this.pdf_last_rendertimes[n];return t/i},paging_handled_by_animator:!1,push_pdf_rendertime:function(n){this.pdf_last_rendertimes[this.pdf_last_rendertime_index++]=n;this.pdf_last_rendertime_index>=this.pdf_last_rendertime_max&&(this.pdf_last_rendertime_index=0)},last_page:-1,last_page_left:-1,last_page_right:-1,last_autozoom:1,current_page:0,get current_page_firstvalid(){return this.current_page<=0?1:this.current_page>this.page_count?this.page_count:this.current_page},get current_page_left(){return this.current_page<=1?this.current_page=0:(this.current_mode==this.constant.DOUBLE||this.current_mode==this.constant.DOUBLE_REVERSE)&&this.current_page%2&&this.current_page--,this.current_page},get current_page_right(){return this.current_page_left+1},get show_page_left(){return this.showPage(this.current_page_left)},get show_page_right(){return this.showPage(this.current_page_right)},get can_go_back(){if(this.current_mode==this.constant.DOUBLE||this.current_mode==this.constant.DOUBLE_REVERSE){if(Math.min(this.current_page_left,this.current_page_right)<=1)return!1}else if(this.current_page<=1)return!1;return!0},get can_go_forward(){if(this.current_mode==this.constant.DOUBLE||this.current_mode==this.constant.DOUBLE_REVERSE){if(Math.max(this.current_page_left,this.current_page_right)>=this.page_count)return!1}else if(this.current_page>=this.page_count)return!1;return!0},showPage:function(n){return n>0&&n<=this.page_count},_lastContentContained:null,_contentContainedInvalidated:!0,get contentContained(){if(this._contentContainedInvalidated){var n={width:this.page_container.getWidth(),height:this.page_container.getHeight()},i={width:t.reader.container.getWidth(),height:t.reader.container.getHeight()};this._lastContentContained=n.width<=i.width&&n.height<=i.height;this._contentContainedInvalidated=!1}return this._lastContentContained},invalidateContentContained:function(){this._contentContainedInvalidated=!0},constant:{SINGLE:1,DOUBLE:2,SINGLE_REVERSE:3,DOUBLE_REVERSE:4,SCROLL:5,PREV_LEFT:0,PREV_RIGHT:1,CUR_LEFT:2,CUR_RIGHT:3,NEXT_LEFT:4,NEXT_RIGHT:5,PREV:0,CUR:1,NEXT:2,IMG:1,PDF:2,NONE:0,FADE:1,FLIP:2,SWIPE:3},ready_for_first_load:!1,first_load_done:!1,onFirstLoad:function(){!this.first_load_done&&this.ready_for_first_load&&(this.first_load_done=!0,t.e(".main-loader").addClass("hidden"),(t.pager.is_mobile||t.reader.settings.no_pdf)&&t.reader.setProgress(100),t.pager.setAnimation(t.pager.constant[t.reader.get("animation","flip").toUpperCase()]),t.reader.settings.slideshow_mode&&t.reader.slideshow.play())},init:function(){var n=this,c,o,h;if(this.page_container=t.e("#reader-container .content .pages"),this.content_container=t.e("#reader-container .content"),this.pages!=null){this.prepareElements();t.reader.settings.overview_start_open&&t.reader.overview.open();var r,s,l,u,f,i=0,a=0,e=null,v=null;t.TouchHandler(this.content_container,{propagate:!0,wheelTick:t.reader.settings.zoom_wheel_step*10,onSwipeRight:function(){t.pager.touchBlocked||t.reader.settings.enable_swiping&&!t.pager.paging_handled_by_animator&&(t.pager.current_animator==null?t.pager.goBack():t.pager.current_animator.doFullAnimationPrev())},onSwipeLeft:function(){t.pager.touchBlocked||t.reader.settings.enable_swiping&&!t.pager.paging_handled_by_animator&&(t.pager.current_animator==null?t.pager.goForward():t.pager.current_animator.doFullAnimationNext())},onDrag:function(n){t.pager.touchBlocked||t.reader.settings.enable_dragging&&(t.pager.content_container[0].scrollLeft+=n.x,t.pager.content_container[0].scrollTop+=n.y)},onDoubleTap:function(r){if(!t.pager.touchBlocked&&t.reader.settings.enable_double_tapping)if(n.current_autozoom){i=1/n.current_zoom;var u=r.y*i-n.content_container.getHeight()/2,f=r.x*i-n.content_container.getWidth()/2;n.setZoom(t.reader.settings.zoom_doubleclick);n.adjust({reload:!0,scroll:{top:u,left:f},callback:function(){t.pager.content_container[0].scrollLeft=f;t.pager.content_container[0].scrollTop=u}})}else n.current_autozoom=!0,n.adjust({reload:!0})},onWheelStart:function(i){t.pager.touchBlocked||t.reader.settings.enable_mousewheel_zoom&&(r=n.page_container.getWidth(),s=n.page_container.getHeight(),e=i,a=r/n.content_container.getWidth(),u=e.x+n.content_container[0].scrollLeft,f=e.y+n.content_container[0].scrollTop,l=n.page_container.getRelativeBoundingClientRect(),n.page_container.setStyle("transformOrigin","{0}px {1}px".format(u,f)))},onWheel:function(u,f,e){if(!t.pager.touchBlocked&&t.reader.settings.enable_mousewheel_zoom){var o=t.pager.current_zoom*f;o<(t.reader.settings.zoom_min=="auto"?t.pager.last_autozoom:t.reader.settings.zoom_min)?f=(t.reader.settings.zoom_min=="auto"?t.pager.last_autozoom:t.reader.settings.zoom_min)/t.pager.current_zoom:o>t.reader.settings.zoom_max&&(f=t.reader.settings.zoom_max/t.pager.current_zoom);i=f;v=e;n.page_container.setStyle("padding","{0}px".format(n.current_padding*(1/i)));n.page_container.setStyle("height","{0}px".format(s));n.page_container.setStyle("width","{0}px".format(r));n.page_container.setStyle("transform","scale({0})".format(i))}},onWheelEnd:function(){var r,o,e;if(!t.pager.touchBlocked&&t.reader.settings.enable_mousewheel_zoom){try{r=n.page_container.getRelativeBoundingClientRect()}catch(s){}t.pager.setZoom(t.pager.current_zoom*i);o=Math.round(-r.top);e=Math.round(-r.left);n.current_mode==n.constant.DOUBLE&&(e-=(r.right-n.page_container.getRelativeBoundingClientRect().right)/2);t.pager.adjust({reload:!0,scroll:{top:o,left:e},callback:function(){r?(t.pager.content_container[0].scrollTop=o,t.pager.content_container[0].scrollLeft=e):(t.pager.content_container[0].scrollLeft=u*i-n.content_container.getWidth()/2-n.current_padding,t.pager.content_container[0].scrollTop=f*i-n.content_container.getHeight()/2-n.current_padding)}})}},onPinchStart:function(i){t.pager.touchBlocked||t.reader.settings.enable_pinching&&(r=n.page_container.getWidth(),s=n.page_container.getHeight(),e=i,a=r/n.content_container.getWidth(),u=e.x+n.content_container[0].scrollLeft,f=e.y+n.content_container[0].scrollTop,l=n.page_container.getRelativeBoundingClientRect(),n.page_container.setStyle("transformOrigin","{0}px {1}px".format(u,f)))},onPinch:function(u,f,e){if(!t.pager.touchBlocked&&t.reader.settings.enable_pinching){var o=t.pager.current_zoom*f;o>=t.pager.last_autozoom&&o<=t.reader.settings.zoom_max&&(i=f,v=e,n.page_container.setStyle("padding","{0}px".format(n.current_padding*(1/i))),n.page_container.setStyle("height","{0}px".format(s)),n.page_container.setStyle("width","{0}px".format(r)),n.page_container.setStyle("transform","scale({0})".format(i)))}},onPinchEnd:function(){var r,o,e;if(!t.pager.touchBlocked&&t.reader.settings.enable_pinching){try{r=n.page_container.getRelativeBoundingClientRect()}catch(s){}t.pager.setZoom(t.pager.current_zoom*i);o=Math.round(-r.top);e=Math.round(-r.left);n.current_mode==n.constant.DOUBLE&&(e-=(r.right-n.page_container.getRelativeBoundingClientRect().right)/2);t.pager.adjust({reload:!0,scroll:{top:o,left:e},callback:function(){r?(t.pager.content_container[0].scrollTop=o,t.pager.content_container[0].scrollLeft=e):(t.pager.content_container[0].scrollLeft=u*i-n.content_container.getWidth()/2-n.current_padding,t.pager.content_container[0].scrollTop=f*i-n.content_container.getHeight()/2-n.current_padding)}})}}});this.is_mobile=t.browser.isMobile;t.e(document).on("keyup",function(n){n.keyCode==37&&t.reader.settings.enable_keyboard_navigation&&(t.pager.current_animator==null?t.pager.goBack():t.pager.current_animator.doFullAnimationPrev());n.keyCode==39&&t.reader.settings.enable_keyboard_navigation&&(t.pager.current_animator==null?t.pager.goForward():t.pager.current_animator.doFullAnimationNext());n.keyCode==107;n.keyCode==109});c=null;t.pager.content_container.on("resize",function(){clearTimeout(c);c=setTimeout(function(){t.pager.invalidateContentContained();t.pager.adjust()},50)});this.adjust();o=null;for(h in this.pages){if(o!=null&&(this.pages[h].ref_size.width!=o.width||this.pages[h].ref_size.height!=o.height)){this.pages_uniform=!1;break}o=this.pages[h].ref_size}this.ready_for_first_load=!0;this.current_page=t.reader.settings.start_page;this.goToPage(this.current_page)}},setAnimation:function(n,i){var r=t.pager,u=r.constant;(!r.pages_uniform||r.is_mobile)&&(n=u.NONE);t.pager.page_container.removeClass("flip fade swipe");switch(r.current_animation){case u.FLIP:t.flip_animator.destruct();break;case u.SWIPE:t.swipe_animator.destruct()}r.current_animator=null;switch(n){case u.FLIP:r.current_animation=u.FLIP;t.reader.settings.preload=!0;t.flip_animator.init();t.pager.page_container.addClass("flip");r.current_animator=t.flip_animator;break;case u.FADE:r.current_animation=u.FADE;t.reader.settings.preload=!0;t.pager.page_container.addClass("fade");break;case u.SWIPE:r.current_animation=u.SWIPE;t.reader.settings.preload=!0;t.swipe_animator.init();t.pager.page_container.addClass("swipe");r.current_animator=t.swipe_animator;break;default:r.current_animation=u.NONE}r.adjust({reload:!0,callback:i})},setZoom:function(n,i){var r=Math.min(t.reader.settings.zoom_max,Math.max(t.reader.settings.zoom_min=="auto"?this.last_autozoom:t.reader.settings.zoom_min,n));this.current_zoom=r;t.PDFManager.scale=r;i||(this.current_autozoom=!1);this.invalidateContentContained()},adjust:function(n){var i=t.pager,u=i.constant,s=n?n.callback:null,e=n?n.reload:!1,f,r,o;i.current_mode_manual||(f=-1,f=t.reader.container.getWidth()>t.reader.container.getHeight()?u.DOUBLE:u.SINGLE,f!=-1&&f!=i.current_mode&&(i.current_mode=f,e=!0));i.current_mode==u.SINGLE&&i.current_page==0&&(i.current_page=1);i.current_renderer_manual||(r=-1,i.is_mobile||t.reader.settings.no_pdf?r=u.IMG:!t.browser.isMobile&&i.pdf_enabled&&i.pdf_loaded?r=u.PDF:t.browser.isMobile||i.pdf_enabled||i.pdf_checking||i.pdf_preparing||i.preparePdf(),r!=-1&&r!=i.current_renderer&&(i.current_renderer=r,e=!0));i.current_autozoom&&(o=i.calculateAutozoom(),o!=i.current_zoom&&(i.setZoom(o,!0),e=!0));e&&(i.prepareElements(),n&&n.scroll&&(t.pager.content_container[0].scrollLeft=n.scroll.left,t.pager.content_container[0].scrollTop=n.scroll.top),i.goToPage(i.current_page,s,n))},calculateAutozoom:function(){var n=t.pager,r=n.constant,i=n.getPageSize(n.current_page_firstvalid,!0),u={width:t.pager.content_container.getWidth()-n.current_padding*2,height:t.pager.content_container.getHeight()-n.current_padding*2},f={width:n.current_mode==r.DOUBLE||n.current_mode==r.DOUBLE_REVERSE?i.width*2:i.width,height:i.height},e=u.width/f.width,o=u.height/f.height;return n.last_autozoom=e>o?o:e,n.last_autozoom},getFileName:function(n){return n},getFullPath:function(n){return t.reader.path+"/images/"+this.getFileName(n)+".jpg"},getThumbPath:function(n){return t.reader.path+"/thumbs/"+this.getFileName(n)+".jpg"},getPDFPath:function(){return t.reader.path+"/pdf/"+this.getFileName("full")+".pdf"},getPageSize:function(n,t){return this.pages[n]?t?{width:this.pages[n].ref_size.width,height:this.pages[n].ref_size.height}:{width:this.pages[n].ref_size.width*this.current_zoom,height:this.pages[n].ref_size.height*this.current_zoom}:{width:0,height:0}},prepareElements:function(){var n,i=this.constant,r,u;if(this.holders.length==0)for(r=this.getPageSize(1),n=0;n<6;n++)this.holders[n]=t.e("<div>",{"class":"page"}).appendTo(this.page_container),u=t.e("<div>",{"class":"wrapper"}).appendTo(this.holders[n]),this.loaders[n]=t.reader.stageLoader().appendTo(u),t.e("<canvas>",{"class":"loading"}).appendTo(u),this.holders[n].setAttr("style","width: {0}px; height: {1}px;".format(r.width,r.height));if(this.current_mode==i.SINGLE||this.current_mode==i.SINGLE_REVERSE)for(this.page_container.addClass("single").removeClass("double"),n=0;n<6;n++)this.holders[n].removeClass("previous next left right"),n==i.CUR?this.holders[n].removeClass("hidden previous next"):n==i.PREV?this.holders[n].removeClass("next").addClass("hidden previous"):n==i.NEXT?this.holders[n].removeClass("previous").addClass("hidden next"):this.holders[n].addClass("hidden").removeClass("previous next");else if(this.current_mode==i.DOUBLE||this.current_mode==i.DOUBLE_REVERSE)for(this.page_container.addClass("double").removeClass("single"),n=0;n<6;n++)n==i.CUR_LEFT||n==i.CUR_RIGHT?this.holders[n].removeClass("previous next"):n==i.PREV_LEFT||n==i.PREV_RIGHT?this.holders[n].removeClass("next").addClass("previous"):(n==i.NEXT_LEFT||n==i.NEXT_RIGHT)&&this.holders[n].removeClass("previous").addClass("next"),n==i.CUR_LEFT&&this.show_page_left?this.holders[n].removeClass("hidden"):n==i.CUR_RIGHT&&this.show_page_right?this.holders[n].removeClass("hidden"):this.holders[n].addClass("hidden"),n==i.CUR_LEFT||n==i.PREV_LEFT||n==i.NEXT_LEFT?this.holders[n].addClass("left").removeClass("right"):n==i.CUR_RIGHT||n==i.PREV_RIGHT||n==i.NEXT_RIGHT?this.holders[n].addClass("right").removeClass("left"):this.holders[n].removeClass("left right")},preparePdf:function(){this.pdf_checked||this.pdf_checking||(this.pdf_checking=!0,t.net.request(this.getPDFPath(),{method:"HEAD",finished:function(n){t.pager.pdf_exists=n;t.pager.pdf_checked=!0;t.pager.pdf_checking=!1;n?(t.pager.pdf_preparing=!0,t.pager.preparePdfJs()):(t.pager.pdf_preparing=!1,t.reader.setProgress("error"))}}))},preparePdfJs:function(){var i=t.e("script"),n=null;i.each(function(){if(this.src.contains("magalone."))return n=this.src,!1});n!=null&&(t.pager.current_script=n,t.pager.loadPdfJsCompat(function(){t.pager.loadPdfJsMain(function(){t.pager.pdf_preparing=!1;t.pager.pdf_enabled=!0;t.PDFManager.setOnDocumentLoadHandler(t.pager.pdfJsOnLoad);t.PDFManager.setOnDocumentProgressHandler(t.pager.pdfJsOnProgress);t.PDFManager.setOnPageLoadHandler(t.pager.pdfJsOnPage);t.PDFManager.setOnPageRenderHandler(t.pager.pdfJsOnRender);t.PDFManager.loadFile(t.pager.getPDFPath())})}))},loadPdfJsCompat:function(n){var u=t.pager.current_script.substr(0,t.pager.current_script.lastIndexOf("/")),f=u+"/pdfjs/compatibility"+(t.pager.current_script.contains(".min")?".min":"")+".js",i=document.createElement("script"),r=!1;i.onload=function(){r||n();r=!0};i.setAttribute("src",f);document.getElementsByTagName("head")[0].appendChild(i)},loadPdfJsMain:function(n){var u=t.pager.current_script.substr(0,t.pager.current_script.lastIndexOf("/")),f=u+"/pdfjs/pdf"+(t.pager.current_script.contains(".min")?".min":"")+".js",i=document.createElement("script"),r=!1;i.onload=function(){r||n();r=!0};i.setAttribute("src",f);document.getElementsByTagName("head")[0].appendChild(i)},goBack:function(n,i){var r=t.pager,u=r.constant;switch(r.current_mode){case u.SINGLE:if(r.current_page<=1)return;r.current_page--;break;case u.DOUBLE:if(r.current_page==0)return;r.current_page-=2}r.goToPage(r.current_page,n,{onReady:i})},goForward:function(n,i){var r=t.pager,u=r.constant;switch(r.current_mode){case u.SINGLE:if(r.current_page>=r.page_count)return;r.current_page++;break;case u.DOUBLE:if(r.current_page_left>=r.page_count||r.current_page_right>=r.page_count)return;r.current_page+=2}r.goToPage(r.current_page,n,{onReady:i})},goToPage:function(n,i,r){var u=this.constant;t.reader.overview.scrollToCurrentPage();this.renderStop();this.current_mode==u.SINGLE||this.current_mode==u.SINGLE_REVERSE?(this.renderSingle(i,r),t.reader.settings.enable_arrows&&(this.current_page<=1?t.e(".ctrl.btn.go-back").addClass("gone"):t.e(".ctrl.btn.go-back").removeClass("gone"),this.current_page>=this.page_count?t.e(".ctrl.btn.go-fwd").addClass("gone"):t.e(".ctrl.btn.go-fwd").removeClass("gone"))):this.current_mode==u.DOUBLE&&(this.renderDouble(i,r),t.reader.settings.enable_arrows&&(this.current_page_left==0?t.e(".ctrl.btn.go-back").addClass("gone"):t.e(".ctrl.btn.go-back").removeClass("gone"),this.current_page_left==this.page_count||this.current_page_right==this.page_count?t.e(".ctrl.btn.go-fwd").addClass("gone"):t.e(".ctrl.btn.go-fwd").removeClass("gone")));t.overlays.render()},checkAndCallback:function(n){n&&t.is.function(n)&&n()},renderStop:function(){t.PDFQueue.reset();clearTimeout(this.renderTimeout)},renderInstance:0,renderTimeout:null,renderWaitingTime:2e3,renderSingleSelf:function(n){var i={};return i.callback=n,i.this=t.pager,i.iid=++i.this.renderInstance,i.CONST=i.this.constant,i.scrollPerformed=!1,i.cur=i.this.current_page_firstvalid,i.next=i.this.current_page_firstvalid+1,i.prev=i.this.current_page_firstvalid-1,i.pageSize=i.this.getPageSize(i.cur),i.pageSizeNext=i.this.getPageSize(i.next),i.pageSizePrev=i.this.getPageSize(i.prev),i.canvas=i.this.holders[i.CONST.CUR].find("canvas"),i.canvasNext=i.this.holders[i.CONST.NEXT].find("canvas"),i.canvasPrev=i.this.holders[i.CONST.PREV].find("canvas"),i.containerWidth=i.pageSize.width+i.this.current_padding*2,i.containerHeight=i.pageSize.height+i.this.current_padding*2,i.readjust=Math.round(i.containerHeight)!=Math.round(i.this.page_container.getHeight())||Math.round(i.containerWidth)!=Math.round(i.this.page_container.getWidth()),i},renderSingle:function(n,i){var r=t.pager.renderSingleSelf(n),u;if(r.readjust&&i&&i.adjusted&&(r.readjust=!1),r.readjust)return r.this.page_container.setAttr("style","padding: {0}px; width: {1}px; height: {2}px;".format(r.this.current_padding,r.containerWidth,r.containerHeight)),i&&i.scroll&&r.scrollPerformed==!1&&(r.scrollPerformed=!0,t.pager.content_container[0].scrollLeft=i.scroll.left,t.pager.content_container[0].scrollTop=i.scroll.top),u=t.is.object(i)?i:{},t.extend(u,{reload:!0,callback:n,adjusted:!0}),setTimeout(function(){t.pager.adjust(u)},1);var f=!1,e=!1,o=function(){f||(f=!0,r.this.ready_for_first_load&&!r.this.first_load_done&&r.this.onFirstLoad(),r.this.checkAndCallback(r.callback),setTimeout(function(){r.this.prerenderSingleClean(r)},100))},s=function(){e||f||(e=!0,i&&i.scroll&&r.scrollPerformed==!1&&(r.scrollPerformed=!0,t.pager.content_container[0].scrollLeft=i.scroll.left,t.pager.content_container[0].scrollTop=i.scroll.top),setTimeout(function(){i&&i.onReady&&t.is.function(i.onReady)&&i.onReady();r.this.prerenderSingleDirty(r)},100))};r.this.current_renderer==r.CONST.IMG?r.this.renderSingleImg(r,s,o,i):r.this.current_renderer==r.CONST.PDF&&(r.canvas.addClass("loading"),r.this.renderSinglePdf(r,s,o,i))},renderSingleImg:function(n,t,i){var r=!1,u=!1;n.this.holders[n.CONST.CUR].setAttr("style","width: {0}px; height: {1}px;".format(n.pageSize.width,n.pageSize.height));n.this.loaders[n.CONST.CUR].setAttr("style","");n.this.loaders[n.CONST.CUR].load([n.this.getThumbPath(n.cur)],function(){r||(r=!0,n.this.checkAndCallback(t),setTimeout(function(){n.this.loaders[n.CONST.CUR].load([n.this.getThumbPath(n.cur),n.this.getFullPath(n.cur)],function(){u||(u=!0,n.this.checkAndCallback(i))})},1))},!0)},renderSinglePdf:function(n,i,r){var u=!1,f=!1;n.this.loaders[n.CONST.CUR].setAttr("style","");n.this.loaders[n.CONST.CUR].load([n.this.getFullPath(n.cur)],function(){n.this.holders[n.CONST.CUR].setAttr("style","width: {0}px; height: {1}px;".format(n.pageSize.width,n.pageSize.height));u||(u=!0,n.this.checkAndCallback(i),n.this.checkAndCallback(r),n.this.renderTimeout=setTimeout(function(){t.PDFQueue.push(n.canvas,n.cur,function(){f||(f=!0,n.canvas.removeClass("loading"))});t.PDFQueue.start()},n.this.renderWaitingTime))},!0)},prerenderSingleDirty:function(n,i){n.this.holders[n.CONST.NEXT].setAttr("style","width: {0}px; height: {1}px;".format(n.pageSizeNext.width,n.pageSizeNext.height));n.this.holders[n.CONST.PREV].setAttr("style","width: {0}px; height: {1}px;".format(n.pageSizePrev.width,n.pageSizePrev.height));t.e([n.canvasNext,n.canvasPrev]).addClass("loading");var u=0,f=n.this.showPage(n.next)+n.this.showPage(n.prev),r=function(){++u==f&&n.this.checkAndCallback(i)};n.this.showPage(n.next)&&n.this.loaders[n.CONST.NEXT].load([n.this.getThumbPath(n.next)],r);n.this.showPage(n.prev)&&n.this.loaders[n.CONST.PREV].load([n.this.getThumbPath(n.prev)],r)},prerenderSingleClean:function(n,i){n.this.holders[n.CONST.NEXT].setAttr("style","width: {0}px; height: {1}px;".format(n.pageSizeNext.width,n.pageSizeNext.height));n.this.holders[n.CONST.PREV].setAttr("style","width: {0}px; height: {1}px;".format(n.pageSizePrev.width,n.pageSizePrev.height));t.e([n.canvasNext,n.canvasPrev]).addClass("loading");var u=0,f=n.this.showPage(n.next)+n.this.showPage(n.prev),r=function(){++u==f&&n.this.checkAndCallback(i)};n.this.showPage(n.next)&&n.this.loaders[n.CONST.NEXT].load([n.this.getThumbPath(n.next),n.this.getFullPath(n.next)],r);n.this.showPage(n.prev)&&n.this.loaders[n.CONST.PREV].load([n.this.getThumbPath(n.prev),n.this.getFullPath(n.prev)],r)},renderDoubleSelf:function(n){var i={};return i.callback=n,i.this=t.pager,i.iid=++i.this.renderInstance,i.CONST=i.this.constant,i.scrollPerformed=!1,i.pageSizeLeft=i.this.getPageSize(i.this.current_page_left),i.pageSizeRight=i.this.getPageSize(i.this.current_page_right),i.pageSizePrevLeft=i.this.getPageSize(i.this.current_page_left-2),i.pageSizePrevRight=i.this.getPageSize(i.this.current_page_right-2),i.pageSizeNextLeft=i.this.getPageSize(i.this.current_page_left+2),i.pageSizeNextRight=i.this.getPageSize(i.this.current_page_right+2),i.canvasLeft=i.this.holders[i.CONST.CUR_LEFT].find("canvas"),i.canvasRight=i.this.holders[i.CONST.CUR_RIGHT].find("canvas"),i.canvasNextLeft=i.this.holders[i.CONST.NEXT_LEFT].find("canvas"),i.canvasNextRight=i.this.holders[i.CONST.NEXT_RIGHT].find("canvas"),i.canvasPrevLeft=i.this.holders[i.CONST.PREV_LEFT].find("canvas"),i.canvasPrevRight=i.this.holders[i.CONST.PREV_RIGHT].find("canvas"),i.left=i.this.current_page_left,i.right=i.this.current_page_right,i.nextLeft=i.this.current_page_left+2,i.nextRight=i.this.current_page_right+2,i.prevLeft=i.this.current_page_left-2,i.prevRight=i.this.current_page_right-2,i.containerWidth=(i.pageSizeLeft.width>i.pageSizeRight.width?i.pageSizeLeft.width*2:i.pageSizeRight.width*2)+i.this.current_padding*2,i.containerHeight=(i.pageSizeLeft.height>i.pageSizeRight.height?i.pageSizeLeft.height:i.pageSizeRight.height)+i.this.current_padding*2,i.readjust=Math.round(i.containerHeight)!=Math.round(i.this.page_container.getHeight())||Math.round(i.containerWidth)!=Math.round(i.this.page_container.getWidth()),i},renderDouble:function(n,i){var r=t.pager.renderDoubleSelf(n),u;if(r.readjust&&i&&i.adjusted&&(r.readjust=!1),r.readjust)return r.this.page_container.setAttr("style","padding: {0}px; width: {1}px; height: {2}px;".format(r.this.current_padding,r.containerWidth,r.containerHeight)),i&&i.scroll&&r.scrollPerformed==!1&&(r.scrollPerformed=!0,t.pager.content_container[0].scrollLeft=i.scroll.left,t.pager.content_container[0].scrollTop=i.scroll.top),u=t.is.object(i)?i:{},t.extend(u,{reload:!0,callback:n,adjusted:!0}),setTimeout(function(){t.pager.adjust(u)},1);var f=!1,e=!1,o=function(){f||(f=!0,r.this.ready_for_first_load&&!r.this.first_load_done&&r.this.onFirstLoad(),r.this.checkAndCallback(r.callback),setTimeout(function(){r.this.prerenderDoubleClean(r)},100))},s=function(){e||f||(e=!0,i&&i.scroll&&r.scrollPerformed==!1&&(r.scrollPerformed=!0,t.pager.content_container[0].scrollLeft=i.scroll.left,t.pager.content_container[0].scrollTop=i.scroll.top),setTimeout(function(){i&&i.onReady&&t.is.function(i.onReady)&&i.onReady();r.this.prerenderDoubleDirty(r)},100))};r.this.current_renderer==r.CONST.IMG?r.this.renderDoubleImg(r,s,o,i):r.this.current_renderer==r.CONST.PDF&&(t.e([r.canvasLeft,r.canvasRight,r.canvasNextLeft,r.canvasNextRight,r.canvasPrevLeft,r.canvasPrevRight]).addClass("loading"),r.this.renderDoublePdf(r,s,o,i))},renderDoubleImg:function(n,t,i){var r=!1,u=!1,f=n.this.showPage(n.left)+n.this.showPage(n.right),h=0,c=f,l=0,e=function(){++h==f&&(r=!0,n.this.checkAndCallback(t))},o=function(){++l==c&&(u=!0,n.this.checkAndCallback(i))},s=function(){setTimeout(function(){n.this.show_page_left&&n.this.loaders[n.CONST.CUR_LEFT].load([n.this.getThumbPath(n.left),n.this.getFullPath(n.left)],function(){u||o()});n.this.show_page_right&&n.this.loaders[n.CONST.CUR_RIGHT].load([n.this.getThumbPath(n.right),n.this.getFullPath(n.right)],function(){u||o()})},1)};n.this.show_page_left?(n.this.holders[n.CONST.CUR_LEFT].removeClass("hidden"),n.this.holders[n.CONST.CUR_LEFT].setAttr("style","width: {0}px; height: {1}px;".format(n.pageSizeLeft.width,n.pageSizeLeft.height)),n.this.loaders[n.CONST.CUR_LEFT].setAttr("style",""),n.this.loaders[n.CONST.CUR_LEFT].load([n.this.getThumbPath(n.left)],function(){r||(e(),r&&s())},!0)):n.this.holders[n.CONST.CUR_LEFT].addClass("hidden");n.this.show_page_right?(n.this.holders[n.CONST.CUR_RIGHT].removeClass("hidden"),n.this.holders[n.CONST.CUR_RIGHT].setAttr("style","width: {0}px; height: {1}px;".format(n.pageSizeRight.width,n.pageSizeRight.height)),n.this.loaders[n.CONST.CUR_RIGHT].setAttr("style",""),n.this.loaders[n.CONST.CUR_RIGHT].load([n.this.getThumbPath(n.right)],function(){r||(e(),r&&s())},!0)):n.this.holders[n.CONST.CUR_RIGHT].addClass("hidden")},renderDoublePdf:function(n,i,r){var u=!1,f=!1,e=n.this.showPage(n.left)+n.this.showPage(n.right),c=e,l=0,a=0,o=function(){++l==e&&(u=!0,n.this.checkAndCallback(i),n.this.checkAndCallback(r))},s=function(){++a==c&&(f=!0)},h=function(){n.this.renderTimeout=setTimeout(function(){n.this.show_page_left&&t.PDFQueue.push(n.canvasLeft,n.left,function(){n.canvasLeft.removeClass("loading");f||s()});n.this.show_page_right&&t.PDFQueue.push(n.canvasRight,n.right,function(){n.canvasRight.removeClass("loading");f||s()});t.PDFQueue.start()},n.this.renderWaitingTime)};n.this.show_page_left?(n.this.holders[n.CONST.CUR_LEFT].removeClass("hidden"),n.this.holders[n.CONST.CUR_LEFT].setAttr("style","width: {0}px; height: {1}px;".format(n.pageSizeLeft.width,n.pageSizeLeft.height)),n.this.loaders[n.CONST.CUR_LEFT].setAttr("style",""),n.this.loaders[n.CONST.CUR_LEFT].load([n.this.getFullPath(n.left)],function(){u||(o(),u&&h())},!0)):n.this.holders[n.CONST.CUR_LEFT].addClass("hidden");n.this.show_page_right?(n.this.holders[n.CONST.CUR_RIGHT].removeClass("hidden"),n.this.holders[n.CONST.CUR_RIGHT].setAttr("style","width: {0}px; height: {1}px;".format(n.pageSizeRight.width,n.pageSizeRight.height)),n.this.loaders[n.CONST.CUR_RIGHT].setAttr("style",""),n.this.loaders[n.CONST.CUR_RIGHT].load([n.this.getFullPath(n.right)],function(){u||(o(),u&&h())},!0)):n.this.holders[n.CONST.CUR_RIGHT].addClass("hidden")},prerenderDoubleDirty:function(n,i){n.this.holders[n.CONST.NEXT_LEFT].setAttr("style","width: {0}px; height: {1}px;".format(n.pageSizeNextLeft.width,n.pageSizeNextLeft.height));n.this.holders[n.CONST.NEXT_RIGHT].setAttr("style","width: {0}px; height: {1}px;".format(n.pageSizeNextRight.width,n.pageSizeNextRight.height));n.this.holders[n.CONST.PREV_LEFT].setAttr("style","width: {0}px; height: {1}px;".format(n.pageSizePrevLeft.width,n.pageSizePrevLeft.height));n.this.holders[n.CONST.PREV_RIGHT].setAttr("style","width: {0}px; height: {1}px;".format(n.pageSizePrevRight.width,n.pageSizePrevRight.height));t.e([n.canvasNextLeft,n.canvasNextRight,n.canvasPrevLeft,n.canvasPrevRight]).addClass("loading");var u=0,f=n.this.showPage(n.nextLeft)+n.this.showPage(n.nextRight)+n.this.showPage(n.prevLeft)+n.this.showPage(n.prevRight),r=function(){++u==f&&n.this.checkAndCallback(i)};n.this.showPage(n.nextLeft)&&n.this.loaders[n.CONST.NEXT_LEFT].load([n.this.getThumbPath(n.nextLeft)],r);n.this.showPage(n.nextRight)&&n.this.loaders[n.CONST.NEXT_RIGHT].load([n.this.getThumbPath(n.nextRight)],r);n.this.showPage(n.prevLeft)&&n.this.loaders[n.CONST.PREV_LEFT].load([n.this.getThumbPath(n.prevLeft)],r);n.this.showPage(n.prevRight)&&n.this.loaders[n.CONST.PREV_RIGHT].load([n.this.getThumbPath(n.prevRight)],r)},prerenderDoubleClean:function(n,i){n.this.holders[n.CONST.NEXT_LEFT].setAttr("style","width: {0}px; height: {1}px;".format(n.pageSizeNextLeft.width,n.pageSizeNextLeft.height));n.this.holders[n.CONST.NEXT_RIGHT].setAttr("style","width: {0}px; height: {1}px;".format(n.pageSizeNextRight.width,n.pageSizeNextRight.height));n.this.holders[n.CONST.PREV_LEFT].setAttr("style","width: {0}px; height: {1}px;".format(n.pageSizePrevLeft.width,n.pageSizePrevLeft.height));n.this.holders[n.CONST.PREV_RIGHT].setAttr("style","width: {0}px; height: {1}px;".format(n.pageSizePrevRight.width,n.pageSizePrevRight.height));t.e([n.canvasNextLeft,n.canvasNextRight,n.canvasPrevLeft,n.canvasPrevRight]).addClass("loading");var u=0,f=n.this.showPage(n.nextLeft)+n.this.showPage(n.nextRight)+n.this.showPage(n.prevLeft)+n.this.showPage(n.prevRight),r=function(){++u==f&&n.this.checkAndCallback(i)};n.this.showPage(n.nextLeft)&&n.this.loaders[n.CONST.NEXT_LEFT].load([n.this.getThumbPath(n.nextLeft),n.this.getFullPath(n.nextLeft)],r);n.this.showPage(n.nextRight)&&n.this.loaders[n.CONST.NEXT_RIGHT].load([n.this.getThumbPath(n.nextRight),n.this.getFullPath(n.nextRight)],r);n.this.showPage(n.prevLeft)&&n.this.loaders[n.CONST.PREV_LEFT].load([n.this.getThumbPath(n.prevLeft),n.this.getFullPath(n.prevLeft)],r);n.this.showPage(n.prevRight)&&n.this.loaders[n.CONST.PREV_RIGHT].load([n.this.getThumbPath(n.prevRight),n.this.getFullPath(n.prevRight)],r)},pdfJsOnLoad:function(){t.pager.pdf_loaded_load=!0;t.pager.pdf_loaded=t.pager.pdf_loaded_load&&t.pager.pdf_loaded_progess;t.pager.pdf_loaded&&t.pager.adjust()},pdfJsOnProgress:function(n){var i=t.math.Percentage.XofY(n.loaded,n.total);t.reader.setProgress(i);i>=100&&(t.pager.pdf_loaded_progess=!0,t.pager.pdf_loaded=t.pager.pdf_loaded_load&&t.pager.pdf_loaded_progess,t.pager.pdf_loaded&&t.pager.adjust())},pdfJsOnPage:function(){},pdfJsOnRender:function(){}},TouchHandler:function(n,i){var et=i.swipeThreshold||125,bt=i.moveThreshold||10,ot=i.swipeCancel||70,st=i.doubleTapCancel||200,ht=i.wheelCancel||500,p=i.wheelTick||1,g=1,ct=-1,w=!0,r,h,f,b,nt,tt,it,s,c,o,v,rt,l,ut,a,k=p,d;l=o=s=c=a=!1;var u=t.e(n),ft=function(n){return n<0?-1:1},y=function(){return u[0].scrollHeight<=u.getHeight()||u[0].scrollWidth<=u.getWidth()},lt=function(n){if(n.type!="mouseleave"){var u=t.e(n.srcElement);if(!u.getParents().hasClass("ctrl"))if(v){if(v=!1,clearTimeout(rt),u.getAttr("id")==d.getAttr("id")&&u.getAttr("class")==d.getAttr("class")&&i.onDoubleTap&&t.is.function(i.onDoubleTap))i.onDoubleTap(e(n)||f||r)}else v=!0,d=u,rt=setTimeout(function(){v=!1},st)}},e=function(n){var i=u.getPageXY();if(n.type.startsWith("touch")){if(n.touches.length==1)return{x:n.touches[0].pageX-i.x,y:n.touches[0].pageY-i.y};if(n.touches.length==2){var r={x:n.touches[0].pageX-i.x,y:n.touches[0].pageY-i.y},f={x:n.touches[1].pageX-i.x,y:n.touches[1].pageY-i.y},e=t.math.Midpoint2D(r,f);return{x:e.x,y:e.y,dist:t.math.Dist2D(r,f)}}}else return{x:n.pageX-i.x,y:n.pageY-i.y}},at=function(n){if(!t.e(n.srcElement).getParents().hasClass("ctrl"))if(t.pager.content_container[0].focus(),n&&n.preventDefault&&n.preventDefault(),!w&&n&&n.stopPropagation&&n.stopPropagation(),b=n.type.startsWith("touch"),b&&n.touches.length>=2){if(o=!0,c=s=!1,r=f=e(n),i.onPinchStart&&t.is.function(i.onPinchStart))i.onPinchStart(r)}else y()?(c=!0,r=e(n)):(s=!0,f=e(n))},vt=function(n){var h,c;if(n&&n.preventDefault&&n.preventDefault(),!w&&n&&n.stopPropagation&&n.stopPropagation(),l||(u.addClass("speed"),l=!0),o){var h=e(n),c=h.dist-r.dist,a=h.dist/r.dist;if(i.onPinch&&t.is.function(i.onPinch))i.onPinch(c,a,h)}else if(!y()&&s&&(h=e(n),c={x:f.x-h.x,y:f.y-h.y},i.onDrag&&t.is.function(i.onDrag)))i.onDrag(c);(b||!y())&&(f=e(n))},yt=function(n){if(n&&n.preventDefault&&n.preventDefault(),!w&&n&&n.stopPropagation&&n.stopPropagation(),l&&(u.removeClass("speed"),l=!1),o||lt(n),y()&&c)h=n.type.startsWith("touch")&&f!=null&&f!=undefined?f:e(n)||r,it=t.math.Dist2D(r,h),tt=Math.abs(r.y-h.y),nt=r.x>h.x?g:ct,it>et&&tt<ot&&(nt==g?i.onSwipeLeft&&t.is.function(i.onSwipeLeft)&&i.onSwipeLeft():i.onSwipeRight&&t.is.function(i.onSwipeRight)&&i.onSwipeRight()),c=!1;else if(o){if(i.onPinchEnd&&t.is.function(i.onPinchEnd))i.onPinchEnd(f);o=!1}else s=!1},pt=function(n){if(n&&n.preventDefault&&n.preventDefault(),n&&n.stopPropagation&&n.stopPropagation(),!o&&!s){if(!a&&(a=!0,r=e(n),k=10,i.onWheelStart&&t.is.function(i.onWheelStart)))i.onWheelStart(r);k+=p*-ft(n.deltaY);var u=e(n),f=p*ft(n.deltaY),h=k/10;if(i.onWheel&&t.is.function(i.onWheel))i.onWheel(f,h,u);clearTimeout(ut);ut=setTimeout(wt,ht)}},wt=function(){if(a){if(i.onWheelEnd&&t.is.function(i.onWheelEnd))i.onWheelEnd(r);a=!1}};u.on("wheel",pt);u.on("mousedown touchstart",at);u.on("mouseleave mouseup touchend",yt);u.on("mousemove touchmove",vt)},PDFQueue:{queue:[],current_callback:null,runnning:!1,qid:0,push:function(n,i,r,u){this.queue.push({canvas:n,page:i,callback:r,prerender:u||!1,qid:t.PDFQueue.qid})},reset:function(){this.qid++;this.queue=[]},start:function(n){this.current_callback=n;this.runnning||(this.runnning=!0,this._render())},_render:function(){var i=t.PDFQueue,n=i.queue.pop(),r=!1,f=t.pager.constant,u=(new Date).getTime();if(n)if(r=n.qid==t.PDFQueue.qid,r)try{t.PDFManager.renderPageOn(n.page,t.reader.render_canvas,function(){if(t.pager.push_pdf_rendertime((new Date).getTime()-u),n.qid==t.PDFQueue.qid){var r=n.canvas[0].getContext("2d");n.canvas[0].width=t.reader.render_canvas[0].width;n.canvas[0].height=t.reader.render_canvas[0].height;r.drawImage(t.reader.render_canvas[0],0,0);n.callback&&t.is.function(n.callback)&&n.callback()}i._render()})}catch(e){i._render()}else i._render();else i.runnning=!1,i.current_callback&&t.is.function(i.current_callback)&&i.current_callback()}},PDFManager:{DEBUG_SYMBOL:"PDFM",document:null,pages:{},scale:1,ref_factor:-1,_rendering:!1,_loading:0,get isRendering(){return this._rendering},get isLoading(){return this._loading>0},loadFile:function(n,i){this._loading++;PDFJS.getDocument(n,null,null,this.onDocumentProgress).then(function(n){i&&t.is.function(i)&&i(n);t.PDFManager.onDocumentLoad(n)})},getPage:function(n,i){this.pages.hasOwnProperty(n)?i&&t.is.function(i)&&i(this.pages[n]):this.document!=null&&this.document.getPage(parseInt(n)).then(function(n){i&&t.is.function(i)&&i(n);t.PDFManager.onPageLoad(n)},function(t){console.error("GetPageChainException",t,t.stack,"for page",n,"Callback on:",i)}).then(null,function(t){console.error("GetPageUncaughtException",t,t.stack,"for page",n,"Callback on:",i)})},renderPageOn:function(n,i,r,u){var f,o;if(t.isExElement(i)!=!1&&i.length==1){if(n==0||n>this.document.numPages){r&&t.is.function(r)&&r();return}if(this._rendering=!0,f={canvasContext:i[0].getContext("2d"),viewport:null},this.pages.hasOwnProperty(n)){this.ref_factor==-1&&u!==!0?(f.viewport=this.pages[n].getViewport(1),o=t.pager.getPageSize(n,!0),this.ref_factor=o.width/f.viewport.width):this.ref_factor==-1&&u==!0&&(this.ref_factor=1);f.viewport=this.pages[n].getViewport(this.scale*this.ref_factor);i[0].width=f.viewport.width;i[0].height=f.viewport.height;try{this.pages[n].render(f).promise.then(function(n){t.PDFManager._rendering=!1;r&&t.is.function(r)&&r(n);t.PDFManager.onPageRender(n)},function(u){console.error("RenderPageOn_ChainException",u,u.stack,"for page",n,"on canvas",i,"callback on:",r);t.PDFManager._rendering=!1;r&&t.is.function(r)&&r(!1);t.PDFManager.onPageRender(!1)}).then(null,function(u){console.error("RenderPageOn_UncaughtException",u,u.stack,"for page",n,"on canvas",i,"callback on:",r);t.PDFManager._rendering=!1;r&&t.is.function(r)&&r(!1);t.PDFManager.onPageRender(!1)})}catch(e){console.error("RenderPageOn_FatalException",e,e.stack,"for page",n,"on canvas",i,"callback on:",r);t.PDFManager._rendering=!1;r&&t.is.function(r)&&r(!1);t.PDFManager.onPageRender(!1)}}else try{this.getPage(n,function(){t.PDFManager.renderPageOn(n,i,r,u)})}catch(e){console.error("GetPageChainException",e,e.stack,"for page",n,"Callback on:",r)}}},_handlerOnDocumentLoad:null,_handlerOnDocumentProgress:null,_handlerOnPageLoad:null,_handlerOnPageRender:null,setOnDocumentLoadHandler:function(n){n&&t.is.function(n)&&(this._handlerOnDocumentLoad=n)},setOnDocumentProgressHandler:function(n){n&&t.is.function(n)&&(this._handlerOnDocumentProgress=n)},setOnPageLoadHandler:function(n){n&&t.is.function(n)&&(this._handlerOnPageLoad=n)},setOnPageRenderHandler:function(n){n&&t.is.function(n)&&(this._handlerOnPageRender=n)},onDocumentLoad:function(n){var i=t.PDFManager;i.document=n;i._handlerOnDocumentLoad!=null&&t.is.function(i._handlerOnDocumentLoad)&&i._handlerOnDocumentLoad(n)},onDocumentProgress:function(n){var i=t.PDFManager;n&&n.loaded&&n.total&&n.loaded>=n.total&&(i._loading--,i._loading<0&&(i._loading=0));i._handlerOnDocumentProgress!=null&&t.is.function(i._handlerOnDocumentProgress)&&i._handlerOnDocumentProgress(n)},onPageLoad:function(n){var i=t.PDFManager;i.pages[n.pageNumber]=n;i._handlerOnPageLoad!=null&&t.is.function(i._handlerOnPageLoad)&&i._handlerOnPageLoad(n)},onPageRender:function(n){var i=t.PDFManager;i._handlerOnPageRender!=null&&t.is.function(i._handlerOnPageRender)&&i._handlerOnPageRender(n)}},utf8_encode:function(n){var i,r,t;for(n=n.replace(/\r\n/g,"\n"),i="",r=0;r<n.length;r++)t=n.charCodeAt(r),t<128?i+=String.fromCharCode(t):t>127&&t<2048?(i+=String.fromCharCode(t>>6|192),i+=String.fromCharCode(t&63|128)):(i+=String.fromCharCode(t>>12|224),i+=String.fromCharCode(t>>6&63|128),i+=String.fromCharCode(t&63|128));return i},utf8_decode:function(n){for(var r="",t=0,i=c1=c2=0;t<n.length;)i=n.charCodeAt(t),i<128?(r+=String.fromCharCode(i),t++):i>191&&i<224?(c2=n.charCodeAt(t+1),r+=String.fromCharCode((i&31)<<6|c2&63),t+=2):(c2=n.charCodeAt(t+1),c3=n.charCodeAt(t+2),r+=String.fromCharCode((i&15)<<12|(c2&63)<<6|c3&63),t+=3);return r},sha1:function(n){var c=function(n,t){return n<<t|n>>>32-t},a=function(n){for(var i="",r,t=7;t>=0;t--)r=n>>>t*4&15,i+=r.toString(16);return i},v,t,d,o=new Array(80),y=1732584193,p=4023233417,w=2562383102,b=271733878,k=3285377520,f,i,r,u,s,h,e,l;for(n=this.utf8_encode(n),e=n.length,l=[],t=0;t<e-3;t+=4)d=n.charCodeAt(t)<<24|n.charCodeAt(t+1)<<16|n.charCodeAt(t+2)<<8|n.charCodeAt(t+3),l.push(d);switch(e%4){case 0:t=2147483648;break;case 1:t=n.charCodeAt(e-1)<<24|8388608;break;case 2:t=n.charCodeAt(e-2)<<24|n.charCodeAt(e-1)<<16|32768;break;case 3:t=n.charCodeAt(e-3)<<24|n.charCodeAt(e-2)<<16|n.charCodeAt(e-1)<<8|128}for(l.push(t);l.length%16!=14;)l.push(0);for(l.push(e>>>29),l.push(e<<3&4294967295),v=0;v<l.length;v+=16){for(t=0;t<16;t++)o[t]=l[v+t];for(t=16;t<=79;t++)o[t]=c(o[t-3]^o[t-8]^o[t-14]^o[t-16],1);for(f=y,i=p,r=w,u=b,s=k,t=0;t<=19;t++)h=c(f,5)+(i&r|~i&u)+s+o[t]+1518500249&4294967295,s=u,u=r,r=c(i,30),i=f,f=h;for(t=20;t<=39;t++)h=c(f,5)+(i^r^u)+s+o[t]+1859775393&4294967295,s=u,u=r,r=c(i,30),i=f,f=h;for(t=40;t<=59;t++)h=c(f,5)+(i&r|i&u|r&u)+s+o[t]+2400959708&4294967295,s=u,u=r,r=c(i,30),i=f,f=h;for(t=60;t<=79;t++)h=c(f,5)+(i^r^u)+s+o[t]+3395469782&4294967295,s=u,u=r,r=c(i,30),i=f,f=h;y=y+f&4294967295;p=p+i&4294967295;w=w+r&4294967295;b=b+u&4294967295;k=k+s&4294967295}return h=a(y)+a(p)+a(w)+a(b)+a(k),h.toLowerCase()},md5:function(n){function a(n,t){return n<<t|n>>>32-t}function o(n,t){var f,e,r,u,i;return(r=n&2147483648,u=t&2147483648,f=n&1073741824,e=t&1073741824,i=(n&1073741823)+(t&1073741823),f&e)?i^2147483648^r^u:f|e?i&1073741824?i^3221225472^r^u:i^1073741824^r^u:i^r^u}function yt(n,t,i){return n&t|~n&i}function pt(n,t,i){return n&i|t&~i}function wt(n,t,i){return n^t^i}function bt(n,t,i){return t^(n|~i)}function s(n,t,i,r,u,f,e){return n=o(n,o(o(yt(t,i,r),u),e)),o(a(n,f),t)}function h(n,t,i,r,u,f,e){return n=o(n,o(o(pt(t,i,r),u),e)),o(a(n,f),t)}function c(n,t,i,r,u,f,e){return n=o(n,o(o(wt(t,i,r),u),e)),o(a(n,f),t)}function l(n,t,i,r,u,f,e){return n=o(n,o(o(bt(t,i,r),u),e)),o(a(n,f),t)}function kt(n){for(var r,u=n.length,o=u+8,s=(o-o%64)/64,e=(s+1)*16,i=Array(e-1),f=0,t=0;t<u;)r=(t-t%4)/4,f=t%4*8,i[r]=i[r]|n.charCodeAt(t)<<f,t++;return r=(t-t%4)/4,f=t%4*8,i[r]=i[r]|128<<f,i[e-2]=u<<3,i[e-1]=u>>>29,i}function v(n){for(var i="",r="",u,t=0;t<=3;t++)u=n>>>t*8&255,r="0"+u.toString(16),i=i+r.substr(r.length-2,2);return i}function dt(n){var i,r,t;for(n=n.replace(/\r\n/g,"\n"),i="",r=0;r<n.length;r++)t=n.charCodeAt(r),t<128?i+=String.fromCharCode(t):t>127&&t<2048?(i+=String.fromCharCode(t>>6|192),i+=String.fromCharCode(t&63|128)):(i+=String.fromCharCode(t>>12|224),i+=String.fromCharCode(t>>6&63|128),i+=String.fromCharCode(t&63|128));return i}var e=Array(),f,ht,ct,lt,at,t,i,r,u,y=7,p=12,w=17,b=22,k=5,d=9,g=14,nt=20,tt=4,it=11,rt=16,ut=23,ft=6,et=10,ot=15,st=21,vt;for(n=dt(n),e=kt(n),t=1732584193,i=4023233417,r=2562383102,u=271733878,f=0;f<e.length;f+=16)ht=t,ct=i,lt=r,at=u,t=s(t,i,r,u,e[f+0],y,3614090360),u=s(u,t,i,r,e[f+1],p,3905402710),r=s(r,u,t,i,e[f+2],w,606105819),i=s(i,r,u,t,e[f+3],b,3250441966),t=s(t,i,r,u,e[f+4],y,4118548399),u=s(u,t,i,r,e[f+5],p,1200080426),r=s(r,u,t,i,e[f+6],w,2821735955),i=s(i,r,u,t,e[f+7],b,4249261313),t=s(t,i,r,u,e[f+8],y,1770035416),u=s(u,t,i,r,e[f+9],p,2336552879),r=s(r,u,t,i,e[f+10],w,4294925233),i=s(i,r,u,t,e[f+11],b,2304563134),t=s(t,i,r,u,e[f+12],y,1804603682),u=s(u,t,i,r,e[f+13],p,4254626195),r=s(r,u,t,i,e[f+14],w,2792965006),i=s(i,r,u,t,e[f+15],b,1236535329),t=h(t,i,r,u,e[f+1],k,4129170786),u=h(u,t,i,r,e[f+6],d,3225465664),r=h(r,u,t,i,e[f+11],g,643717713),i=h(i,r,u,t,e[f+0],nt,3921069994),t=h(t,i,r,u,e[f+5],k,3593408605),u=h(u,t,i,r,e[f+10],d,38016083),r=h(r,u,t,i,e[f+15],g,3634488961),i=h(i,r,u,t,e[f+4],nt,3889429448),t=h(t,i,r,u,e[f+9],k,568446438),u=h(u,t,i,r,e[f+14],d,3275163606),r=h(r,u,t,i,e[f+3],g,4107603335),i=h(i,r,u,t,e[f+8],nt,1163531501),t=h(t,i,r,u,e[f+13],k,2850285829),u=h(u,t,i,r,e[f+2],d,4243563512),r=h(r,u,t,i,e[f+7],g,1735328473),i=h(i,r,u,t,e[f+12],nt,2368359562),t=c(t,i,r,u,e[f+5],tt,4294588738),u=c(u,t,i,r,e[f+8],it,2272392833),r=c(r,u,t,i,e[f+11],rt,1839030562),i=c(i,r,u,t,e[f+14],ut,4259657740),t=c(t,i,r,u,e[f+1],tt,2763975236),u=c(u,t,i,r,e[f+4],it,1272893353),r=c(r,u,t,i,e[f+7],rt,4139469664),i=c(i,r,u,t,e[f+10],ut,3200236656),t=c(t,i,r,u,e[f+13],tt,681279174),u=c(u,t,i,r,e[f+0],it,3936430074),r=c(r,u,t,i,e[f+3],rt,3572445317),i=c(i,r,u,t,e[f+6],ut,76029189),t=c(t,i,r,u,e[f+9],tt,3654602809),u=c(u,t,i,r,e[f+12],it,3873151461),r=c(r,u,t,i,e[f+15],rt,530742520),i=c(i,r,u,t,e[f+2],ut,3299628645),t=l(t,i,r,u,e[f+0],ft,4096336452),u=l(u,t,i,r,e[f+7],et,1126891415),r=l(r,u,t,i,e[f+14],ot,2878612391),i=l(i,r,u,t,e[f+5],st,4237533241),t=l(t,i,r,u,e[f+12],ft,1700485571),u=l(u,t,i,r,e[f+3],et,2399980690),r=l(r,u,t,i,e[f+10],ot,4293915773),i=l(i,r,u,t,e[f+1],st,2240044497),t=l(t,i,r,u,e[f+8],ft,1873313359),u=l(u,t,i,r,e[f+15],et,4264355552),r=l(r,u,t,i,e[f+6],ot,2734768916),i=l(i,r,u,t,e[f+13],st,1309151649),t=l(t,i,r,u,e[f+4],ft,4149444226),u=l(u,t,i,r,e[f+11],et,3174756917),r=l(r,u,t,i,e[f+2],ot,718787259),i=l(i,r,u,t,e[f+9],st,3951481745),t=o(t,ht),i=o(i,ct),r=o(r,lt),u=o(u,at);return vt=v(t)+v(i)+v(r)+v(u),vt.toLowerCase()}};exHelp.extend(i)}(window);exHelp.e(document).on("ready",function(){exHelp.reader.init()});
/*
//# sourceMappingURL=magalone.min.js.map
*/